/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.IOException;
import org.beetl.core.ByteWriter;
import org.jetbrains.annotations.Range;

public class IntIOWriter {
    private static final String INT_MIN_VALUE_STR = "-2147483648";
    private static final String LONG_MIN_VALUE_STR = "-9223372036854775808";
    private static final int[] INT_MAX_VALUE_POSITIVES = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final long[] LONG_MAX_VALUE_POSITIVES = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};
    private static final char[] DIGIT_CHAR_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] DIGIT_TEN_CHAR_ARRAY = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] DIGIT_ONE_CHAR_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final int DEFAULT_INT_CHAR_ARRAY_CACHE_CAPACITY = 1024;
    private static final Object[] INT_CHAR_ARRAY_CACHE = new Object[1024];

    public static void writeInt(ByteWriter out, int value) throws IOException {
        if (0 <= value && value < 1024) {
            char[] buf = (char[])INT_CHAR_ARRAY_CACHE[value];
            out.writeNumberChars(buf, buf.length);
            return;
        }
        if (value == Integer.MIN_VALUE) {
            out.writeString(INT_MIN_VALUE_STR);
            return;
        }
        int size = value < 0 ? IntIOWriter.calcStringLength(-value) + 1 : IntIOWriter.calcStringLength(value);
        char[] buf = out.getLocalBuffer().getCharBuffer();
        IntIOWriter.fillChars(value, size, buf);
        out.writeNumberChars(buf, size);
    }

    public static void writeLong(ByteWriter out, long value) throws IOException {
        if (value == Long.MIN_VALUE) {
            out.writeString(LONG_MIN_VALUE_STR);
            return;
        }
        int size = value < 0L ? IntIOWriter.calcStringLength(-value) + 1 : IntIOWriter.calcStringLength(value);
        char[] buf = out.getLocalBuffer().getCharBuffer();
        IntIOWriter.fillChars(value, size, buf);
        out.writeNumberChars(buf, size);
    }

    static void fillChars(int value, int valueStringSize, char[] res) {
        int r;
        int q;
        int charPos = valueStringSize;
        int sign = 0;
        if (value < 0) {
            sign = 45;
            value = -value;
        }
        while (value >= 65536) {
            q = value / 100;
            r = value - ((q << 6) + (q << 5) + (q << 2));
            value = q;
            res[--charPos] = DIGIT_ONE_CHAR_ARRAY[r];
            res[--charPos] = DIGIT_TEN_CHAR_ARRAY[r];
        }
        do {
            q = value * 52429 >>> 19;
            r = value - ((q << 3) + (q << 1));
            res[--charPos] = DIGIT_CHAR_ARRAY[r];
        } while ((value = q) != 0);
        if (sign != 0) {
            res[--charPos] = sign;
        }
    }

    static void fillChars(long value, int valueStringSize, char[] res) {
        int q2;
        int r;
        int charPos = valueStringSize;
        int sign = 0;
        if (value < 0L) {
            sign = 45;
            value = -value;
        }
        while (value > Integer.MAX_VALUE) {
            long q = value / 100L;
            r = (int)(value - ((q << 6) + (q << 5) + (q << 2)));
            value = q;
            res[--charPos] = DIGIT_ONE_CHAR_ARRAY[r];
            res[--charPos] = DIGIT_TEN_CHAR_ARRAY[r];
        }
        int i2 = (int)value;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            res[--charPos] = DIGIT_ONE_CHAR_ARRAY[r];
            res[--charPos] = DIGIT_TEN_CHAR_ARRAY[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            res[--charPos] = DIGIT_CHAR_ARRAY[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            res[--charPos] = sign;
        }
    }

    static int calcStringLength(@Range(from=0L, to=0x7FFFFFFFL) int positiveNumber) {
        int i = 0;
        while (positiveNumber > INT_MAX_VALUE_POSITIVES[i]) {
            ++i;
        }
        return i + 1;
    }

    static int calcStringLength(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long positiveNumber) {
        int i = 0;
        while (positiveNumber > LONG_MAX_VALUE_POSITIVES[i]) {
            ++i;
        }
        return i + 1;
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            IntIOWriter.INT_CHAR_ARRAY_CACHE[i] = String.valueOf(i).toCharArray();
        }
    }
}

