/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.executor.s.nashorn;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.noear.luffy.executor.IJtExecutor;
import org.noear.luffy.executor.s.nashorn.__JTEAPI_CLZ;
import org.noear.luffy.model.AFileModel;
import org.noear.luffy.utils.Datetime;
import org.noear.luffy.utils.ThreadData;
import org.noear.luffy.utils.Timecount;
import org.noear.luffy.utils.Timespan;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;

public class NashornJtExecutor
implements IJtExecutor {
    private static final ThreadData<StringBuilder> _tlBuilder = new ThreadData(() -> new StringBuilder(5120));
    private static final String _lock = "";
    private static NashornJtExecutor _g;
    private final ScriptEngine _eng;
    private final Invocable _eng_call;
    private final Set<String> _loaded_names = Collections.synchronizedSet(new HashSet());
    private final Bindings _bindings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NashornJtExecutor singleton() {
        if (_g != null) return _g;
        String string = _lock;
        synchronized (_lock) {
            if (_g != null) return _g;
            _g = new NashornJtExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _g;
        }
    }

    private NashornJtExecutor() {
        System.setProperty("nashorn.args", "--language=es6");
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this._eng = scriptEngineManager.getEngineByName("nashorn");
        this._eng_call = (Invocable)((Object)this._eng);
        this._bindings = this._eng.getBindings(100);
        Solon.app().sharedAdd("Context", Context.class);
        Solon.app().sharedAdd("ONode", ONode.class);
        Solon.app().sharedAdd("Datetime", Datetime.class);
        Solon.app().sharedAdd("Timecount", Timecount.class);
        Solon.app().sharedAdd("Timespan", Timespan.class);
        Solon.app().shared().forEach((k, v) -> {
            if (!(v instanceof Class)) {
                this.sharedSet((String)k, v);
            }
        });
        Solon.app().onSharedAdd((k, v) -> this.sharedSet((String)k, v));
        this.sharedSet("__JTEAPI", new __JTEAPI_CLZ());
        try {
            this._eng.eval("load('nashorn:mozilla_compat.js');");
            StringBuilder sb = new StringBuilder();
            sb.append("var __global={lib:{},lib_new:{}};\n");
            sb.append("Date.prototype.toJSON =function(){ return this.getTime()};\n");
            Solon.app().shared().forEach((k, v) -> {
                if (v instanceof Class) {
                    Class v2 = (Class)v;
                    sb.append("const ");
                    sb.append((String)k);
                    sb.append(" = Java.type('");
                    sb.append(v2.getName());
                    sb.append("');\n");
                }
            });
            sb.append("function modelAndView(tml,mod){return __JTEAPI.modelAndView(tml,mod);};\n");
            sb.append("function callX(path,attrs){return __JTEAPI.call(path,attrs);};\n");
            sb.append("function requireX(path){  if(path.startsWith('$')){       path=__JTEAPI.getResolvedPath(path);       __JTEAPI.require(path);       return __global.lib_new[path]();}  else{       path=__JTEAPI.getResolvedPath(path);       __JTEAPI.require(path);       return __global.lib[path];}};\n");
            sb.append("function stringify_java(k,v){if(v){if(v.getTicks){return v.getTicks()}if(v.getTime){return v.getTime()}if(v.putAll){var obj={};v.forEach(function(k2,v2){obj[k2]=v2});return obj}if(v.addAll){var ary=[];v.forEach(function(v2){ary.push(v2)});return ary}}return v};\n");
            sb.append("function API_RUN(api){var rst=api(Context.current());if(rst===null){return null}else{if(typeof(rst)=='object'){return JSON.stringify(rst,stringify_java)}else{return rst}}};\n");
            this._eng.eval(sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sharedSet(String name, Object val) {
        this._eng.put(name, val);
    }

    public String language() {
        return "javascript";
    }

    public boolean isLoaded(String name2) {
        return this._loaded_names.contains(name2) && this._bindings.containsKey(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preLoad(String name2, AFileModel file) throws Exception {
        if (!this.isLoaded(name2)) {
            String string = name2.intern();
            synchronized (string) {
                if (!this.isLoaded(name2)) {
                    this._eng.eval(this.compilerAsFun(name2, file));
                    this._loaded_names.add(name2);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(String name) {
        String name2 = name.replace(".", "_").replace("*", "_");
        String string = name2.intern();
        synchronized (string) {
            this._loaded_names.remove(name2);
            this._loaded_names.remove(name2 + "__lib");
        }
    }

    public void delAll() {
        this._loaded_names.clear();
    }

    public Object exec(String name, AFileModel file, Context ctx, Map<String, Object> model, boolean outString) throws Exception {
        String name2 = name.replace(".", "_").replace("*", "_");
        this.preLoad(name2, file);
        if (outString) {
            Object api = this._eng.get("API_" + name2);
            if (api == null) {
                this.del(name);
                throw new RuntimeException("\u63a5\u53e3\u672a\u627e\u5230\u6216\u521d\u59cb\u5316\u5931\u8d25");
            }
            Object tmp = this._eng_call.invokeFunction("API_RUN", api);
            if (tmp == null) {
                return null;
            }
            return tmp.toString();
        }
        return this._eng_call.invokeFunction("API_" + name2, ctx);
    }

    public Object exec(String code, Map<String, Object> model) throws Exception {
        if (model != null) {
            Bindings bindings = this._eng.createBindings();
            bindings.putAll(this._bindings);
            bindings.putAll((Map<? extends String, ? extends Object>)model);
            return this._eng.eval(code, bindings);
        }
        return this._eng.eval(code);
    }

    public String compilerAsFun(String name, AFileModel file) {
        StringBuilder sb = (StringBuilder)_tlBuilder.get();
        sb.setLength(0);
        sb.append("this.API_").append(name).append("=function(ctx){");
        sb.append("\r\n\r\n");
        sb.append(file.content);
        sb.append("\r\n\r\n};");
        if (name.endsWith("__lib")) {
            sb.append("__global.lib['").append(file.path).append("']=").append("new API_").append(name).append("();");
            sb.append("__global.lib_new['").append(file.path).append("']=function(){").append("return new API_").append(name).append("();};");
        }
        return sb.toString();
    }
}

