/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import org.noear.redisx.RedisClient;

public class RedisLock {
    private final RedisClient client;
    private final String lockName;

    public RedisLock(RedisClient client, String lockName) {
        this.client = client;
        this.lockName = lockName;
    }

    public boolean tryLock(int inSeconds, String inMaster) {
        return this.client.openAndGet(ru -> ru.key(this.lockName).expire(inSeconds).lock(inMaster));
    }

    public boolean tryLock(int inSeconds) {
        return this.tryLock(inSeconds, "_");
    }

    public boolean tryLock() {
        return this.tryLock(3);
    }

    public boolean isLocked() {
        return this.client.openAndGet(ru -> ru.key(this.lockName).exists());
    }

    public String getValue() {
        return this.client.openAndGet(ru -> ru.key(this.lockName).get());
    }

    public void unLock(String inMaster) {
        this.client.open(ru -> {
            if (inMaster == null || inMaster.equals(ru.key(this.lockName).get())) {
                ru.key(this.lockName).delete();
            }
        });
    }

    public void unLock() {
        this.unLock(null);
    }
}

