/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import java.util.function.Consumer;
import org.noear.redisx.RedisClient;

public class RedisQueue {
    private final RedisClient client;
    private final String queueName;

    public RedisQueue(RedisClient client, String queueName) {
        this.client = client;
        this.queueName = queueName;
    }

    public void add(String item) {
        this.client.open(session -> session.key(this.queueName).expire(-2).listAdd(item));
    }

    public String pop() {
        return this.client.openAndGet(session -> session.key(this.queueName).listPop());
    }

    public void popAll(Consumer<String> consumer) {
        this.client.open(session -> {
            String item;
            session.key(this.queueName);
            while ((item = session.listPop()) != null) {
                consumer.accept(item);
            }
        });
    }

    public String peek() {
        return this.client.openAndGet(session -> session.key(this.queueName).listPeek());
    }
}

