/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx;

import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.redisx.RedisSession;
import org.noear.redisx.plus.RedisAtomic;
import org.noear.redisx.plus.RedisBus;
import org.noear.redisx.plus.RedisCache;
import org.noear.redisx.plus.RedisId;
import org.noear.redisx.plus.RedisLock;
import org.noear.redisx.plus.RedisQueue;
import org.noear.redisx.utils.TextUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisClient {
    private JedisPool jedisPool;

    public RedisClient(Properties prop) {
        String db = prop.getProperty("db");
        if (TextUtils.isEmpty(db)) {
            throw new RuntimeException("RedisX:Properties lacks the db parameter!");
        }
        this.initDo(prop, Integer.parseInt(db), 0);
    }

    public RedisClient(Properties prop, int db) {
        this.initDo(prop, db, 0);
    }

    public RedisClient(Properties prop, int db, int maxTotaol) {
        this.initDo(prop, db, maxTotaol);
    }

    public RedisClient(String server, String user, String password, int db, int maxTotaol) {
        this.initDo(server, user, password, db, maxTotaol, 0L);
    }

    public RedisClient(String server, String user, String password, int db, int maxTotaol, long maxWaitMillis) {
        this.initDo(server, user, password, db, maxTotaol, maxWaitMillis);
    }

    private void initDo(Properties prop, int db, int maxTotaol) {
        String server = prop.getProperty("server");
        String user = prop.getProperty("user");
        String password = prop.getProperty("password");
        String maxWaitMillis = prop.getProperty("maxWaitMillis");
        String maxTotaolStr = prop.getProperty("maxTotaol");
        if (maxTotaol > 0) {
            this.initDo(server, user, password, db, maxTotaol, TextUtils.isEmpty(maxWaitMillis) ? 0L : Long.parseLong(maxWaitMillis));
        } else {
            this.initDo(server, user, password, db, TextUtils.isEmpty(maxTotaolStr) ? 0 : Integer.parseInt(maxTotaolStr), TextUtils.isEmpty(maxWaitMillis) ? 0L : Long.parseLong(maxWaitMillis));
        }
    }

    private void initDo(String server, String user, String password, int db, int maxTotaol, long maxWaitMillis) {
        int maxIdle;
        JedisPoolConfig config = new JedisPoolConfig();
        if (db < 0) {
            db = 0;
        }
        if (maxTotaol < 20) {
            maxTotaol = 200;
        }
        if ((maxIdle = maxTotaol / 100) < 5) {
            maxIdle = 5;
        }
        if (maxWaitMillis < 3000L) {
            maxWaitMillis = 3000L;
        }
        config.setMaxTotal(maxTotaol);
        config.setMaxIdle(maxIdle);
        config.setMaxWaitMillis(maxWaitMillis);
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        String[] ss = server.split(":");
        if ("".equals(password)) {
            password = null;
        }
        this.jedisPool = new JedisPool((GenericObjectPoolConfig<Jedis>)config, ss[0], Integer.parseInt(ss[1]), 3000, password, db);
    }

    @Deprecated
    public void open0(Consumer<RedisSession> using) {
        this.open(using);
    }

    @Deprecated
    public <T> T open1(Function<RedisSession, T> using) {
        return this.openAndGet(using);
    }

    public void open(Consumer<RedisSession> using) {
        try (RedisSession session = this.openSession();){
            using.accept(session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T openAndGet(Function<RedisSession, T> using) {
        try (RedisSession session = this.openSession();){
            RedisSession redisSession = using.apply(session);
            return (T)redisSession;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RedisSession openSession() {
        Jedis jx = this.jedisPool.getResource();
        return new RedisSession(jx);
    }

    public RedisAtomic getAtomic(String atomicName) {
        return new RedisAtomic(this, atomicName);
    }

    public RedisBus getBus() {
        return new RedisBus(this);
    }

    public RedisCache getCache() {
        return new RedisCache(this);
    }

    public RedisLock getLock(String lockName) {
        return new RedisLock(this, lockName);
    }

    public RedisQueue getQueue(String queueName) {
        return new RedisQueue(this, queueName);
    }

    public RedisId getId(String idName) {
        return new RedisId(this, idName);
    }
}

