/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.redisx.model.HashAll;
import org.noear.redisx.utils.TextUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.SetParams;

public class RedisSession
implements AutoCloseable {
    private static final String LOCK_SUCCEED = "OK";
    private final Jedis jedis;
    private boolean _close = false;
    private String _key;
    private long _seconds;

    protected RedisSession(Jedis jedis) {
        this.jedis = jedis;
    }

    @Override
    public void close() throws Exception {
        if (this._close) {
            return;
        }
        this.jedis.close();
        this._close = true;
    }

    public RedisSession key(String key) {
        this._key = key;
        return this;
    }

    public RedisSession expire(int seconds) {
        this._seconds = seconds;
        return this;
    }

    private void expirePush() {
        if (this._seconds > 0L) {
            this.jedis.expire(this._key, this._seconds);
        }
        if (this._seconds == -1L) {
            this.jedis.expire(this._key, -1L);
        }
        if (this._seconds == -2L) {
            this.jedis.persist(this._key);
        }
    }

    public void delay() {
        this.expirePush();
    }

    public void delay(int seconds) {
        this._seconds = seconds;
        this.expirePush();
    }

    public List<String> scan(String keyPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(count);
        p.match(keyPattern);
        return this.jedis.scan(cursor, p).getResult();
    }

    public boolean match(String keyPattern) {
        List<String> temp = this.scan(keyPattern, 1);
        return temp != null && temp.size() > 0;
    }

    public Boolean exists() {
        return this.jedis.exists(this._key);
    }

    public Boolean delete() {
        return this.jedis.del(this._key) > 0L;
    }

    public void rename(String newKey) {
        this.jedis.rename(this._key, newKey);
    }

    public RedisSession set(String val) {
        this.jedis.set(this._key, val);
        this.expirePush();
        return this;
    }

    public RedisSession set(long val) {
        return this.set(String.valueOf(val));
    }

    public String get() {
        return this.jedis.get(this._key);
    }

    public long getAsLong() {
        String temp = this.get();
        if (TextUtils.isEmpty(temp)) {
            return 0L;
        }
        return Long.parseLong(temp);
    }

    public List<String> getMore(String ... keys) {
        return this.jedis.mget(keys);
    }

    public long incr(long num) {
        long val = this.jedis.incrBy(this._key, num);
        this.expirePush();
        return val;
    }

    public long incr() {
        long val = this.jedis.incr(this._key);
        this.expirePush();
        return val;
    }

    public long decr() {
        long val = this.jedis.decr(this._key);
        this.expirePush();
        return val;
    }

    public boolean lock(String val) {
        SetParams options = new SetParams().nx().ex(this._seconds);
        String rst = this.jedis.set(this._key, val, options);
        return LOCK_SUCCEED.equals(rst);
    }

    public boolean lock() {
        return this.lock(System.currentTimeMillis() + "");
    }

    public Boolean hashHas(String field) {
        return this.jedis.hexists(this._key, field);
    }

    public List<Map.Entry<String, String>> hashScan(String fieldPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(count);
        p.match(fieldPattern);
        return this.jedis.hscan(this._key, cursor, p).getResult();
    }

    public boolean hashMatch(String fieldPattern) {
        List<Map.Entry<String, String>> temp = this.hashScan(fieldPattern, 1);
        return temp != null && temp.size() > 0;
    }

    public long hashDel(String ... fields) {
        return this.jedis.hdel(this._key, fields);
    }

    public RedisSession hashSet(String field, String val) {
        this.jedis.hset(this._key, field, val);
        this.expirePush();
        return this;
    }

    public RedisSession hashSet(String field, long val) {
        return this.hashSet(field, String.valueOf(val));
    }

    public RedisSession hashSetAll(Map<String, String> map) {
        Pipeline pip = this.jedis.pipelined();
        map.forEach((k, v) -> pip.hset(this._key, (String)k, (String)v));
        pip.sync();
        this.expirePush();
        return this;
    }

    public long hashIncr(String field, long num) {
        long val = this.jedis.hincrBy(this._key, field, num);
        this.expirePush();
        return val;
    }

    public String hashGet(String field) {
        return this.jedis.hget(this._key, field);
    }

    public long hashGetAsLong(String field) {
        String temp = this.hashGet(field);
        if (TextUtils.isEmpty(temp)) {
            return 0L;
        }
        return Long.parseLong(temp);
    }

    public List<String> hashGetMore(String ... fields) {
        return this.jedis.hmget(this._key, fields);
    }

    public HashAll hashGetAll() {
        return new HashAll(this.jedis.hgetAll(this._key));
    }

    public long hashLen() {
        return this.jedis.hlen(this._key);
    }

    public RedisSession listAdd(String item) {
        this.jedis.lpush(this._key, item);
        this.expirePush();
        return this;
    }

    public RedisSession listAdd(long item) {
        return this.listAdd(String.valueOf(item));
    }

    public RedisSession listDel(String item, int count) {
        this.jedis.lrem(this._key, (long)count, item);
        this.expirePush();
        return this;
    }

    public RedisSession listDel(String item) {
        return this.listDel(item, 0);
    }

    public RedisSession listAddRange(Collection<String> items) {
        Pipeline pip = this.jedis.pipelined();
        for (String item : items) {
            pip.lpush(this._key, item);
        }
        pip.sync();
        this.expirePush();
        return this;
    }

    public String listPop() {
        return this.jedis.rpop(this._key);
    }

    public String listPeek() {
        return this.listGet(0);
    }

    public String listGet(int index) {
        return this.jedis.lindex(this._key, (long)index);
    }

    public List<String> listGetRange(int start, int end) {
        return this.jedis.lrange(this._key, (long)start, (long)end);
    }

    public long listLen() {
        return this.jedis.llen(this._key);
    }

    public RedisSession setAdd(String item) {
        this.jedis.sadd(this._key, item);
        this.expirePush();
        return this;
    }

    public RedisSession setDel(String item) {
        this.jedis.srem(this._key, item);
        this.expirePush();
        return this;
    }

    public RedisSession setAddRange(Collection<String> items) {
        Pipeline pip = this.jedis.pipelined();
        for (String item : items) {
            pip.sadd(this._key, item);
        }
        pip.sync();
        this.expirePush();
        return this;
    }

    public long setLen() {
        return this.jedis.scard(this._key);
    }

    public String setPop() {
        return this.jedis.spop(this._key);
    }

    public List<String> setGet(int count) {
        return this.jedis.srandmember(this._key, count);
    }

    public List<String> setScan(String itemPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(count);
        p.match(itemPattern);
        return this.jedis.sscan(this._key, cursor, p).getResult();
    }

    public boolean setMatch(String itemPattern) {
        List<String> temp = this.setScan(itemPattern, 1);
        return temp != null && temp.size() > 0;
    }

    public RedisSession zsetAdd(double score, String item) {
        this.jedis.zadd(this._key, score, item);
        this.expirePush();
        return this;
    }

    public void zsetDel(String ... items) {
        this.jedis.zrem(this._key, items);
    }

    public long zsetLen() {
        return this.jedis.zcard(this._key);
    }

    public Set<String> zsetGet(long start, long end) {
        return this.jedis.zrange(this._key, start, end);
    }

    public long zsetIdx(String item) {
        Long tmp = this.jedis.zrank(this._key, item);
        if (tmp == null) {
            return -1L;
        }
        return tmp;
    }

    public List<Tuple> zsetScan(String itemPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(count);
        p.match(itemPattern);
        return this.jedis.zscan(this._key, cursor, p).getResult();
    }

    public boolean zsetMatch(String itemPattern) {
        List<Tuple> temp = this.zsetScan(itemPattern, 1);
        return temp != null && temp.size() > 0;
    }

    public long publish(String channel, String message) {
        return this.jedis.publish(channel, message);
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.jedis.subscribe(jedisPubSub, channels);
    }
}

