/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import java.util.Base64;
import java.util.Set;
import java.util.function.Supplier;
import org.noear.redisx.RedisClient;
import org.noear.redisx.utils.AssertUtil;
import org.noear.redisx.utils.SerializationUtil;

public class RedisBucket {
    private final RedisClient client;

    public RedisBucket(RedisClient client) {
        this.client = client;
    }

    public void store(String key, String val, int inSeconds) {
        this.client.open(s -> s.key(key).expire(inSeconds).set(val));
    }

    public void store(String key, String val) {
        this.client.open(s -> s.key(key).persist().set(val));
    }

    public void storeAndSerialize(String key, Object obj, int inSeconds) {
        AssertUtil.notNull(obj, "redis value cannot be null");
        byte[] bytes = SerializationUtil.serialize(obj);
        String val = Base64.getEncoder().encodeToString(bytes);
        this.client.open(s -> s.key(key).expire(inSeconds).set(val));
    }

    public void storeAndSerialize(String key, Object obj) {
        AssertUtil.notNull(obj, "redis value cannot be null");
        byte[] bytes = SerializationUtil.serialize(obj);
        String val = Base64.getEncoder().encodeToString(bytes);
        this.client.open(s -> s.key(key).persist().set(val));
    }

    public String get(String key) {
        return this.client.openAndGet(s -> s.key(key).get());
    }

    public <T> T getAndDeserialize(String key) {
        String val = this.client.openAndGet(s -> s.key(key).get());
        if (val == null) {
            return null;
        }
        byte[] bytes = Base64.getDecoder().decode(val);
        return (T)SerializationUtil.deserialize(bytes);
    }

    public String getOrStore(String key, int inSeconds, Supplier<String> supplier) {
        String val = this.get(key);
        if (val == null) {
            val = supplier.get();
            this.store(key, val, inSeconds);
        }
        return val;
    }

    public <T> T getOrStoreAndSerialize(String key, int inSeconds, Supplier<T> supplier) {
        T val = this.getAndDeserialize(key);
        if (val == null) {
            val = supplier.get();
            this.storeAndSerialize(key, val, inSeconds);
        }
        return val;
    }

    public void remove(String key) {
        this.client.open(s -> s.key(key).delete());
    }

    public void delay(String key, int inSeconds) {
        this.client.open(s -> s.key(key).delay(inSeconds));
    }

    public long ttl(String key) {
        return this.client.openAndGet(s -> s.key(key).ttl());
    }

    public Set<String> keys(String pattern) {
        return this.client.openAndGet(s -> s.keys(pattern));
    }
}

