/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import java.util.Collection;
import java.util.function.Consumer;
import org.noear.redisx.RedisClient;

public class RedisQueue {
    private final RedisClient client;
    private final String queueName;

    public RedisQueue(RedisClient client, String queueName) {
        this.client = client;
        this.queueName = queueName;
    }

    public void add(String item) {
        this.client.open(s -> s.key(this.queueName).persist().listAdd(item));
    }

    public void addAll(Collection<String> items) {
        this.client.open(s -> s.key(this.queueName).persist().listAddRange(items));
    }

    public String pop() {
        return this.client.openAndGet(s -> s.key(this.queueName).listPop());
    }

    public void popAll(Consumer<String> consumer) {
        this.client.open(s -> {
            String item;
            s.key(this.queueName);
            while ((item = s.listPop()) != null) {
                consumer.accept(item);
            }
        });
    }

    public String peek() {
        return this.client.openAndGet(s -> s.key(this.queueName).listPeek());
    }

    public long size() {
        return this.client.openAndGet(s -> s.key(this.queueName).listLen());
    }

    public void clear() {
        this.client.open(s -> s.key(this.queueName).delete());
    }
}

