/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.noear.redisx.RedisSession;
import org.noear.redisx.model.LocalHash;
import org.noear.redisx.utils.AssertUtil;
import org.noear.redisx.utils.TextUtil;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.resps.GeoRadiusResponse;
import redis.clients.jedis.resps.Tuple;

public class RedisSessionImpl
implements RedisSession {
    private static final String LOCK_SUCCEED = "OK";
    private final UnifiedJedis jedis;
    private String _key;
    private long _milliseconds;

    protected RedisSessionImpl(UnifiedJedis jedis) {
        this.jedis = jedis;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public UnifiedJedis jedis() {
        return this.jedis;
    }

    @Override
    public Long deleteKeys(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return 0L;
        }
        String[] keyAry = new String[keys.size()];
        return this.jedis.del(keys.toArray(keyAry));
    }

    @Override
    public Long existsKeys(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return 0L;
        }
        String[] keyAry = new String[keys.size()];
        return this.jedis.exists(keys.toArray(keyAry));
    }

    @Override
    public RedisSessionImpl key(String key) {
        AssertUtil.notEmpty(key, "redis key cannot be empty");
        this._key = key;
        return this;
    }

    @Override
    public RedisSessionImpl expire(int seconds) {
        this._milliseconds = seconds == -1 ? -1L : TimeUnit.SECONDS.toMillis(seconds);
        return this;
    }

    @Override
    public RedisSessionImpl expire(long time, TimeUnit unit) {
        this._milliseconds = time == -1L ? -1L : unit.toMillis(time);
        return this;
    }

    @Override
    public RedisSessionImpl persist() {
        this._milliseconds = -1L;
        return this;
    }

    private void expirePush() {
        if (this._milliseconds > 0L) {
            this.jedis.pexpire(this._key, this._milliseconds);
        }
        if (this._milliseconds == -1L) {
            this.jedis.persist(this._key);
        }
    }

    @Override
    public void delay() {
        this.expirePush();
    }

    @Override
    public void delay(int seconds) {
        this.expire(seconds);
        this.expirePush();
    }

    @Override
    public void delay(long time, TimeUnit unit) {
        this.expire(time, unit);
        this.expirePush();
    }

    @Override
    public List<String> scan(String keyPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(count);
        p.match(keyPattern);
        return this.jedis.scan(cursor, p).getResult();
    }

    @Override
    public boolean match(String keyPattern) {
        List<String> temp = this.scan(keyPattern, 1);
        return temp != null && temp.size() > 0;
    }

    @Override
    public Boolean exists() {
        return this.jedis.exists(this._key);
    }

    @Override
    public Boolean delete() {
        return this.jedis.del(this._key) > 0L;
    }

    @Override
    public void rename(String newKey) {
        this.jedis.rename(this._key, newKey);
    }

    @Override
    public long ttl() {
        return this.jedis.ttl(this._key);
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.jedis.keys(pattern);
    }

    @Override
    public RedisSessionImpl set(String val) {
        AssertUtil.notNull(val, "redis value cannot be null");
        if (this._milliseconds > 0L) {
            this.jedis.psetex(this._key, this._milliseconds, val);
        } else {
            this.jedis.set(this._key, val);
        }
        return this;
    }

    @Override
    public RedisSessionImpl set(long val) {
        return this.set(String.valueOf(val));
    }

    @Override
    public String get() {
        return this.jedis.get(this._key);
    }

    @Override
    public long getAsLong() {
        String temp = this.get();
        if (TextUtil.isEmpty(temp)) {
            return 0L;
        }
        return Long.parseLong(temp);
    }

    @Override
    public List<String> getMore(String ... keys) {
        return this.jedis.mget(keys);
    }

    @Override
    public long incr(long num) {
        long val = this.jedis.incrBy(this._key, num);
        this.expirePush();
        return val;
    }

    @Override
    public long incr() {
        long val = this.jedis.incr(this._key);
        this.expirePush();
        return val;
    }

    @Override
    public long decr() {
        long val = this.jedis.decr(this._key);
        this.expirePush();
        return val;
    }

    @Override
    public boolean lock(String val) {
        SetParams options = new SetParams().nx().px(this._milliseconds);
        String rst = this.jedis.set(this._key, val, options);
        return LOCK_SUCCEED.equals(rst);
    }

    @Override
    public boolean lock() {
        return this.lock(System.currentTimeMillis() + "");
    }

    @Override
    public Boolean hashHas(String field) {
        return this.jedis.hexists(this._key, field);
    }

    @Override
    public List<Map.Entry<String, String>> hashScan(String fieldPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(count);
        p.match(fieldPattern);
        return this.jedis.hscan(this._key, cursor, p).getResult();
    }

    @Override
    public boolean hashMatch(String fieldPattern) {
        List<Map.Entry<String, String>> temp = this.hashScan(fieldPattern, 1);
        return temp != null && temp.size() > 0;
    }

    @Override
    public long hashDel(String ... fields) {
        return this.jedis.hdel(this._key, fields);
    }

    @Override
    public RedisSessionImpl hashSet(String field, String val) {
        this.jedis.hset(this._key, field, val);
        this.expirePush();
        return this;
    }

    @Override
    public RedisSessionImpl hashSet(String field, long val) {
        return this.hashSet(field, String.valueOf(val));
    }

    @Override
    public RedisSessionImpl hashSetAll(Map<? extends String, ? extends String> map) {
        HashMap<String, String> map2 = new HashMap<String, String>(map);
        this.jedis.hset(this._key, map2);
        this.expirePush();
        return this;
    }

    @Override
    public long hashIncr(String field, long num) {
        long val = this.jedis.hincrBy(this._key, field, num);
        this.expirePush();
        return val;
    }

    @Override
    public String hashGet(String field) {
        return this.jedis.hget(this._key, field);
    }

    @Override
    public long hashGetAsLong(String field) {
        String temp = this.hashGet(field);
        if (TextUtil.isEmpty(temp)) {
            return 0L;
        }
        return Long.parseLong(temp);
    }

    @Override
    public List<String> hashGetMore(String ... fields) {
        return this.jedis.hmget(this._key, fields);
    }

    @Override
    public LocalHash hashGetAll() {
        return new LocalHash(this.jedis.hgetAll(this._key));
    }

    @Override
    public Set<String> hashGetAllKeys() {
        return this.jedis.hkeys(this._key);
    }

    @Override
    public List<String> hashGetAllValues() {
        return this.jedis.hvals(this._key);
    }

    @Override
    public long hashLen() {
        return this.jedis.hlen(this._key);
    }

    @Override
    public RedisSessionImpl listAdd(String item) {
        this.jedis.lpush(this._key, item);
        this.expirePush();
        return this;
    }

    @Override
    public RedisSessionImpl listAdd(long item) {
        return this.listAdd(String.valueOf(item));
    }

    @Override
    public RedisSessionImpl listSet(int index, String newValue) {
        this.jedis.lset(this._key, (long)index, newValue);
        this.expirePush();
        return this;
    }

    @Override
    public RedisSessionImpl listDel(String item, int count) {
        this.jedis.lrem(this._key, (long)count, item);
        this.expirePush();
        return this;
    }

    @Override
    public RedisSessionImpl listDel(String item) {
        return this.listDel(item, 0);
    }

    @Override
    public RedisSessionImpl listDelRange(Collection<? extends String> items) {
        for (String string : items) {
            this.jedis.lrem(this._key, 0L, string);
        }
        this.expirePush();
        return this;
    }

    @Override
    public RedisSessionImpl listAddRange(Collection<? extends String> items) {
        this.jedis.lpush(this._key, items.toArray(new String[items.size()]));
        this.expirePush();
        return this;
    }

    @Override
    public String listPop() {
        return this.jedis.rpop(this._key);
    }

    @Override
    public String listPeek() {
        return this.jedis.lindex(this._key, -1L);
    }

    @Override
    public String listGet(int index) {
        return this.jedis.lindex(this._key, (long)index);
    }

    @Override
    public List<String> listGetRange(int start, int end) {
        return this.jedis.lrange(this._key, (long)start, (long)end);
    }

    @Override
    public List<String> listGetAll() {
        return this.jedis.lrange(this._key, 0L, -1L);
    }

    @Override
    public long listLen() {
        return this.jedis.llen(this._key);
    }

    @Override
    public long setAdd(String item) {
        long tmp = this.jedis.sadd(this._key, item);
        this.expirePush();
        return tmp;
    }

    @Override
    public long setDel(String item) {
        long tmp = this.jedis.srem(this._key, item);
        return tmp;
    }

    @Override
    public RedisSessionImpl setAddRange(Collection<String> items) {
        this.jedis.sadd(this._key, items.toArray(new String[items.size()]));
        this.expirePush();
        return this;
    }

    @Override
    public long setLen() {
        return this.jedis.scard(this._key);
    }

    @Override
    public String setPop() {
        return this.jedis.spop(this._key);
    }

    @Override
    public List<String> setGet(int count) {
        return this.jedis.srandmember(this._key, count);
    }

    @Override
    public List<String> setScan(String itemPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(count);
        p.match(itemPattern);
        return this.jedis.sscan(this._key, cursor, p).getResult();
    }

    @Override
    public boolean setMatch(String itemPattern) {
        List<String> temp = this.setScan(itemPattern, 1);
        return temp != null && temp.size() > 0;
    }

    @Override
    public RedisSessionImpl zsetAdd(double score, String item) {
        this.jedis.zadd(this._key, score, item);
        this.expirePush();
        return this;
    }

    @Override
    public long zsetDel(String ... items) {
        long tmp = this.jedis.zrem(this._key, items);
        return tmp;
    }

    @Override
    public long zsetLen() {
        return this.jedis.zcard(this._key);
    }

    @Override
    public Collection<String> zsetGet(long start, long end) {
        return this.jedis.zrange(this._key, start, end);
    }

    @Override
    public long zsetIdx(String item) {
        Long tmp = this.jedis.zrank(this._key, item);
        if (tmp == null) {
            return -1L;
        }
        return tmp;
    }

    @Override
    public List<Tuple> zsetScan(String itemPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(count);
        p.match(itemPattern);
        return this.jedis.zscan(this._key, cursor, p).getResult();
    }

    @Override
    public boolean zsetMatch(String itemPattern) {
        List<Tuple> temp = this.zsetScan(itemPattern, 1);
        return temp != null && temp.size() > 0;
    }

    @Override
    public long geoAdd(double lng, double lat, String member) {
        long tmp = this.jedis.geoadd(this._key, lng, lat, member);
        this.expirePush();
        return tmp;
    }

    @Override
    public long geoAddAll(Map<String, GeoCoordinate> memberMap) {
        long tmp = this.jedis.geoadd(this._key, memberMap);
        this.expirePush();
        return tmp;
    }

    @Override
    public List<GeoRadiusResponse> geoGetByRadius(double centerLng, double centerLat, long radius) {
        return this.jedis.georadius(this._key, centerLng, centerLat, (double)radius, GeoUnit.M);
    }

    @Override
    public long geoDist(String member1, String member2) {
        return this.jedis.geodist(this._key, member1, member2, GeoUnit.M).longValue();
    }

    @Override
    public long publish(String channel, String message) {
        return this.jedis.publish(channel, message);
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.jedis.subscribe(jedisPubSub, channels);
    }
}

