/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx.plus;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.noear.redisx.RedisClient;
import redis.clients.jedis.JedisPubSub;

public class RedisBus {
    private final RedisClient client;

    public RedisBus(RedisClient client) {
        this.client = client;
    }

    public void subscribe(final BiConsumer<String, String> consumer, String ... topics) {
        this.client.open(s -> s.subscribe(new JedisPubSub(){

            @Override
            public void onMessage(String channel, String message) {
                consumer.accept(channel, message);
            }
        }, topics));
    }

    public CompletableFuture<Thread> subscribeFuture(BiConsumer<String, String> consumer, String ... topics) {
        CompletableFuture<Thread> future = new CompletableFuture<Thread>();
        Thread thread = new Thread(() -> {
            try {
                this.subscribe(consumer, topics);
                future.complete(Thread.currentThread());
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        thread.start();
        return future;
    }

    public void publish(String topic, String message) {
        this.client.open(s -> s.publish(topic, message));
    }
}

