/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.lock.redis;

import java.util.Properties;
import org.noear.luffy.dso.CfgUtil;
import org.noear.luffy.dso.IJtLock;
import org.noear.luffy.dso.JtBridge;
import org.noear.luffy.dso.LogLevel;
import org.noear.luffy.dso.LogUtil;
import org.noear.luffy.utils.ConfigUtils;
import org.noear.redisx.RedisClient;

public class RedisJtLock
implements IJtLock {
    private RedisClient _redisX;

    public RedisJtLock(Properties prop) {
        this._redisX = new RedisClient(prop);
    }

    public static void init(String cfg) throws Exception {
        Properties prop;
        if (cfg == null) {
            return;
        }
        String prop_str = cfg;
        if (cfg.startsWith("@")) {
            prop_str = CfgUtil.cfgGetValue((String)cfg.substring(1));
        }
        if ((prop = ConfigUtils.getProp((String)prop_str)) != null && prop.size() >= 5) {
            JtBridge.lockSet((IJtLock)new RedisJtLock(prop));
        } else {
            LogUtil.log((String)"RedisJtLock", (LogLevel)LogLevel.WARN, (String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u53c2\u6570\u6709\u95ee\u9898", (String)prop_str);
        }
    }

    public boolean tryLock(String group, String key, int inSeconds, String inMaster) {
        String key2 = group + ".lk." + key;
        return this._redisX.getLock(key2).tryLock(inSeconds, inMaster);
    }

    public boolean tryLock(String group, String key, int inSeconds) {
        String key2 = group + ".lk." + key;
        return this._redisX.getLock(key2).tryLock();
    }

    public boolean tryLock(String group, String key) {
        return this.tryLock(group, key, 3);
    }

    public boolean isLocked(String group, String key) {
        String key2 = group + ".lk." + key;
        return this._redisX.getLock(key2).isLocked();
    }

    public void unLock(String group, String key) {
        String key2 = group + ".lk." + key;
        this._redisX.getLock(key2).unLock();
    }
}

