/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.dso;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.noear.luffy.dso.CallUtil;
import org.noear.luffy.dso.DbUtil;
import org.noear.luffy.dso.JtUtil;
import org.noear.luffy.dso.JtUtilEx;
import org.noear.luffy.utils.Base64Utils;
import org.noear.luffy.utils.HttpUtils;
import org.noear.luffy.utils.TextUtils;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.weed.DataList;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;
import org.noear.weed.wrap.DbType;

public class PluginUtil {
    private static DbContext db() {
        return DbUtil.db();
    }

    public static void initRoot(String path) {
        try {
            ((DbTableQuery)PluginUtil.db().table("a_file").set("link_to", (Object)path).whereEq("path", (Object)"/")).update();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void initCfg(String key, String val) {
        try {
            JtUtil.g.cfgSet(key, val);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void initCall(String path) {
        if (TextUtils.isEmpty((String)path)) {
            return;
        }
        try {
            CallUtil.callFile((String)path, (Map)JtUtil.g.empMap());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean install(String packageTag) {
        try {
            return PluginUtil.do_install(packageTag, true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean reinstall(String packageTag) {
        try {
            return PluginUtil.do_install(packageTag, false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void uninstall(String packageTag) {
        if (TextUtils.isEmpty((String)packageTag)) {
            return;
        }
        String tag = packageTag.split("\\.")[0];
        try {
            PluginUtil.db().exe("DELETE FROM a_config WHERE tag=?", new Object[]{tag});
            PluginUtil.db().exe("DELETE FROM a_file WHERE tag=?", new Object[]{tag});
            PluginUtil.db().exe("DELETE FROM a_image WHERE tag=?", new Object[]{tag});
            PluginUtil.db().exe("UPDATE a_plugin SET is_installed=0 WHERE plugin_tag=? ", new Object[]{packageTag});
            PluginUtil.db().exe("DELETE FROM a_plugin WHERE plugin_tag=? AND url='' ", new Object[]{packageTag});
            List dtmp = PluginUtil.db().sql("SHOW TABLES", new Object[0]).getArray(0);
            for (String stb : dtmp) {
                if (stb != tag && !stb.startsWith(tag + '_')) continue;
                PluginUtil.db().exe("DROP TABLE " + stb, new Object[0]);
            }
            JtUtilEx.g2.restart();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void add(String adds) {
        if (!TextUtils.isEmpty((String)adds)) {
            String[] ss;
            for (String packageTag : ss = adds.split(",")) {
                PluginUtil.install(packageTag);
            }
        }
    }

    public static void udp(String adds) {
        if (!TextUtils.isEmpty((String)adds)) {
            String[] ss;
            for (String packageTag : ss = adds.split(",")) {
                PluginUtil.reinstall(packageTag);
            }
        }
    }

    public static void rem(String rems) {
        if (!TextUtils.isEmpty((String)rems)) {
            String[] ss;
            for (String packageTag : ss = rems.split(",")) {
                PluginUtil.uninstall(packageTag);
            }
        }
    }

    private static boolean do_install(String packageTag, boolean onlyInstall) throws Exception {
        if (TextUtils.isEmpty((String)packageTag)) {
            return false;
        }
        if (onlyInstall && ((DbTableQuery)PluginUtil.db().table("a_plugin").whereEq("plugin_tag", (Object)packageTag)).exists()) {
            return false;
        }
        boolean is_ok = PluginUtil._installDo(packageTag);
        if (is_ok) {
            String tag = packageTag.split("\\.")[0];
            List<String> depList = PluginUtil.dependencyGetDo(tag);
            for (String dep : depList) {
                PluginUtil.do_install_dependency(dep);
            }
            JtUtilEx.g2.restart();
        }
        return is_ok;
    }

    private static void do_install_dependency(String packageTag) throws Exception {
        String tag = packageTag.split("\\.")[0];
        if (((DbTableQuery)PluginUtil.db().table("a_plugin").where("tag=? AND is_installed=1", new Object[]{tag})).exists()) {
            return;
        }
        PluginUtil._installDo(packageTag);
    }

    private static List<String> dependencyGetDo(String tag) throws Exception {
        return ((DbTableQuery)PluginUtil.db().table("a_config").where("tag=? AND label=?", new Object[]{tag, "dep.plugin"})).select("value").getDataList().toArray(0);
    }

    private static boolean _installDo(String packageTag) throws Exception {
        String center = Solon.cfg().get("luffy.center");
        if (TextUtils.isEmpty((String)center)) {
            center = (String)Solon.cfg().argx().get((Object)"center");
        }
        if (TextUtils.isEmpty((String)center)) {
            return false;
        }
        String url = null;
        url = center.indexOf("://") > 0 ? center + "/.plugin/pull.jsx?_fapk=1&plugin_tag=" + packageTag : "http://" + center + "/.plugin/pull.jsx?_fapk=1&plugin_tag=" + packageTag;
        String json = new HttpUtils(url).get();
        ONode data = ONode.load((Object)json);
        if (data.get("code").getInt() != 1) {
            return false;
        }
        ONode body = data.get("data").get("body");
        ONode meta = data.get("data").get("meta");
        String plugin_tag = meta.get("plugin_tag").getString();
        String tag = plugin_tag.split("\\.")[0];
        String p_config = body.get("config").getString();
        String p_menu = body.get("menu").getString();
        String p_file = body.get("file").getString();
        String p_img = body.get("image").getString();
        ONode p_table = body.get("dbtable");
        if (!TextUtils.isEmpty((String)p_config)) {
            List pcec = ((DbTableQuery)PluginUtil.db().table("a_config").where("tag=? AND is_exclude=1", new Object[]{tag})).select("name").getArray(0);
            ((DbTableQuery)PluginUtil.db().table("a_config").where("tag=? AND is_exclude=0", new Object[]{tag})).delete();
            String pcfg = Base64Utils.decode((String)p_config);
            List pcfg_d = (List)ONode.deserialize((String)pcfg, List.class);
            for (Map m : pcfg_d) {
                String name = (String)m.get("name");
                Boolean is_modified = (Boolean)m.get("is_modified");
                if (!pcec.contains(name)) {
                    m.remove("cfg_id");
                    PluginUtil.db().table("a_config").setMap(m).insert();
                    continue;
                }
                if (!is_modified.booleanValue()) continue;
                if (m.get("edit_type") == null) {
                    m.put("edit_type", "");
                }
                if (m.get("edit_placeholder") == null) {
                    m.put("edit_placeholder", "");
                }
                if (m.get("note") == null) {
                    m.put("note", "");
                }
                ((DbTableQuery)PluginUtil.db().table("a_config").set("edit_type", m.get("edit_type")).set("edit_placeholder", m.get("edit_placeholder")).set("note", m.get("note")).whereEq("name", (Object)name)).update();
            }
            if (PluginUtil.db().dbType() == DbType.H2) {
                ((DbTableQuery)PluginUtil.db().table("a_config").set("value", (Object)"LocalJt").whereEq("name", (Object)"_frm_admin_title")).update();
            }
        }
        if (!TextUtils.isEmpty((String)p_menu)) {
            List pmec = ((DbTableQuery)PluginUtil.db().table("a_menu").where("tag=? AND is_exclude=1", new Object[]{tag})).select("concat(tag,label,url) name").getArray(0);
            ((DbTableQuery)PluginUtil.db().table("a_menu").where("tag=? AND is_exclude=0", new Object[]{tag})).delete();
            String pmenu = Base64Utils.decode((String)p_menu);
            List pmenu_d = (List)ONode.deserialize((String)pmenu, List.class);
            if (pmenu_d != null) {
                for (Map m : pmenu_d) {
                    String pm_name = m.get("tag") + "" + m.get("label") + m.get("url");
                    if (pmec.contains(pm_name)) continue;
                    m.remove("menu_id");
                    PluginUtil.db().table("a_menu").setMap(m).insert();
                }
            }
        }
        if (!TextUtils.isEmpty((String)p_file)) {
            List pfec = ((DbTableQuery)PluginUtil.db().table("a_file").where("tag=? AND is_exclude=1", new Object[]{tag})).select("path").getArray(0);
            ((DbTableQuery)PluginUtil.db().table("a_file").where("tag=? AND is_exclude=0", new Object[]{tag})).delete();
            String pfile = Base64Utils.decode((String)p_file);
            List pfile_d = (List)ONode.deserialize((String)pfile, List.class);
            if (pfile_d != null) {
                Iterator iterator = pfile_d.iterator();
                while (iterator.hasNext()) {
                    Map m;
                    m = (Map)iterator.next();
                    String path = (String)m.get("path");
                    if (pfec.contains(path)) continue;
                    m.remove("file_id");
                    if (m.get("content") != null) {
                        String c2 = Base64Utils.decode((String)m.get("content").toString());
                        m.put("content", c2);
                    }
                    PluginUtil.db().table("a_file").setMap(m).insert();
                }
            }
        }
        if (!TextUtils.isEmpty((String)p_img)) {
            ((DbTableQuery)PluginUtil.db().table("a_image").whereEq("tag", (Object)tag)).delete();
            String pimg = Base64Utils.decode((String)p_img);
            List pimg_d = (List)ONode.deserialize((String)pimg, List.class);
            if (pimg_d != null) {
                for (Map m : pimg_d) {
                    m.remove("img_id");
                    PluginUtil.db().table("a_image").setMap(m).insert();
                }
            }
        }
        if (p_table.isObject()) {
            for (ONode n : p_table.obj().values()) {
                String v = n.getString();
                v = "CREATE TABLE IF NOT EXISTS " + Base64Utils.decode((String)v).substring(12);
                PluginUtil.db().exe(v, new Object[0]);
            }
        }
        ((DbTableQuery)PluginUtil.db().table("a_plugin").set("is_installed", (Object)0).whereEq("tag", (Object)tag)).update();
        PluginUtil.db().table("a_plugin").set("plugin_tag", (Object)meta.get("plugin_tag").getString()).set("tag", (Object)tag).set("name", (Object)meta.get("name").getString()).set("author", (Object)meta.get("author").getString()).set("contacts", (Object)meta.get("contacts").getString()).set("ver_name", (Object)meta.get("ver_name").getString()).set("ver_code", (Object)meta.get("ver_code").getString()).set("description", (Object)meta.get("description").getString()).set("thumbnail", (Object)meta.get("thumbnail").getString()).set("category", (Object)meta.get("category").getString()).set("is_installed", (Object)1).upsert("plugin_tag");
        int jar_num = 0;
        DataList pjar_d = ((DbTableQuery)((DbTableQuery)((DbTableQuery)PluginUtil.db().table("a_image").whereEq("tag", (Object)tag)).andEq("label", (Object)"dep.jar")).andEq("content_type", (Object)"application/java-archive")).select("path,data,data_md5,note").getDataList();
        for (Map m : pjar_d) {
            String m_note;
            String m_data_md5;
            String m_data;
            String m_path = m.getString("path");
            if (!JtUtilEx.g2.loadJar(m_path, m_data = m.getString("data"), m_data_md5 = m.getString("data_md5"), m_note = m.getString("note"))) continue;
            ++jar_num;
        }
        JtUtilEx.g2.restart();
        return true;
    }
}

