/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.event.http;

import java.util.HashMap;
import java.util.List;
import org.noear.luffy.dso.AFileUtil;
import org.noear.luffy.dso.DbApi;
import org.noear.luffy.dso.DbUtil;
import org.noear.luffy.dso.LogLevel;
import org.noear.luffy.dso.LogUtil;
import org.noear.luffy.executor.ExecutorFactory;
import org.noear.luffy.model.AFileModel;
import org.noear.luffy.utils.ExceptionUtils;
import org.noear.luffy.utils.TextUtils;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;

public class FrmInterceptor
implements Handler {
    private static final String _lock = "";
    private static FrmInterceptor _g = null;
    private static final String _key = "__luffy_standalone_model";
    private HashMap<String, String> _cacheMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FrmInterceptor g() {
        if (_g != null) return _g;
        String string = _lock;
        synchronized (_lock) {
            if (_g != null) return _g;
            _g = new FrmInterceptor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _g;
        }
    }

    private FrmInterceptor() {
        this.reset();
    }

    public void handle(Context ctx) throws Exception {
        String path = ctx.path();
        Object tmp = Solon.global().shared().get(_key);
        ctx.attrSet(_key, tmp);
        this._cacheMap.forEach((path2, suf) -> {
            if (path.startsWith((String)suf)) {
                this.exec(ctx, (String)path2);
            }
        });
    }

    private void exec(Context ctx, String path2) {
        try {
            this.do_exec(ctx, path2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void do_exec(Context ctx, String path2) throws Exception {
        AFileModel file = AFileUtil.get(path2);
        if (file.file_id == 0) {
            return;
        }
        if (!"filter.path".equals(file.label)) {
            return;
        }
        try {
            ExecutorFactory.execOnly((AFileModel)file, (Context)ctx);
        }
        catch (Exception ex) {
            String err = ExceptionUtils.getString((Throwable)ex);
            ctx.output(err);
            LogUtil.log((String)"_file", (String)file.tag, (String)file.path, (LogLevel)LogLevel.ERROR, (String)_lock, (String)err);
            ctx.setHandled(true);
        }
    }

    public void del(String path) {
        if (TextUtils.isEmpty((String)path)) {
            return;
        }
        this._cacheMap.remove(path);
    }

    public void add(String path, String note) {
        if (TextUtils.isEmpty((String)note)) {
            return;
        }
        String suf = note.split("#")[0];
        if (suf.length() > 3 && suf.endsWith("/") && suf.startsWith("/")) {
            this._cacheMap.put(path, suf);
        }
    }

    public void reset() {
        if (DbUtil.db() == null) {
            return;
        }
        try {
            this._cacheMap.clear();
            List<AFileModel> list = DbApi.pathFilters();
            for (AFileModel c : list) {
                String suf;
                if (TextUtils.isEmpty((String)c.note) || (suf = c.note.split("#")[0]).length() <= 3 || !suf.endsWith("/") || !suf.startsWith("/")) continue;
                this._cacheMap.put(c.path, suf);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

