/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.event.http;

import java.util.HashMap;
import java.util.List;
import org.noear.luffy.dso.AFileUtil;
import org.noear.luffy.dso.DbApi;
import org.noear.luffy.dso.DbUtil;
import org.noear.luffy.dso.LogLevel;
import org.noear.luffy.dso.LogUtil;
import org.noear.luffy.executor.ExecutorFactory;
import org.noear.luffy.model.AFileModel;
import org.noear.luffy.utils.ExceptionUtils;
import org.noear.luffy.utils.TextUtils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;

public class SufHandler
implements Handler {
    private static final String _lock = "";
    private static SufHandler _g = null;
    private HashMap<String, String> _cacheMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SufHandler g() {
        if (_g != null) return _g;
        String string = _lock;
        synchronized (_lock) {
            if (_g != null) return _g;
            _g = new SufHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _g;
        }
    }

    private SufHandler() {
        this.reset();
    }

    public void handle(Context ctx) throws Exception {
        String path = ctx.path();
        for (String suf : this._cacheMap.keySet()) {
            if (!path.endsWith(suf)) continue;
            ctx.setHandled(true);
            this.exec(ctx, this._cacheMap.get(suf));
            return;
        }
    }

    private void exec(Context ctx, String path) throws Exception {
        String path2 = path;
        String name = path2.replace("/", "__");
        AFileModel file = AFileUtil.get(path2);
        if (file.file_id == 0) {
            ctx.status(404);
            return;
        }
        if (!"filter.file".equals(file.label)) {
            return;
        }
        try {
            ExecutorFactory.exec((String)name, (AFileModel)file, (Context)ctx);
        }
        catch (Throwable ex) {
            String error = ExceptionUtils.getString((Throwable)ex);
            LogUtil.log((String)"_file", (String)file.tag, (String)file.path, (LogLevel)LogLevel.ERROR, (String)_lock, (String)error);
            ctx.status(500);
            ctx.output(error);
        }
    }

    public void del(String note) {
        if (TextUtils.isEmpty((String)note)) {
            return;
        }
        String suf = note.split("#")[0];
        if (suf.length() > 0) {
            if (suf.startsWith(".")) {
                this._cacheMap.remove(suf);
            } else {
                this._cacheMap.remove("." + suf);
            }
        }
    }

    public void add(String path, String note) {
        if (TextUtils.isEmpty((String)note)) {
            return;
        }
        String suf = note.split("#")[0];
        if (suf.length() > 0) {
            if (suf.startsWith(".")) {
                this._cacheMap.put(suf, path);
            } else {
                this._cacheMap.put("." + suf, path);
            }
        }
    }

    public void reset() {
        if (DbUtil.db() == null) {
            return;
        }
        try {
            this._cacheMap.clear();
            List<AFileModel> list = DbApi.fileFilters();
            for (AFileModel c : list) {
                String suf;
                if (TextUtils.isEmpty((String)c.note) || (suf = c.note.split("#")[0]).length() <= 0) continue;
                if (suf.startsWith(".")) {
                    this._cacheMap.put(suf, c.path);
                    continue;
                }
                this._cacheMap.put("." + suf, c.path);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

