/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.dso;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import org.noear.luffy.dso.DbApi;
import org.noear.luffy.dso.DbUtil;
import org.noear.luffy.dso.JtUtil;
import org.noear.luffy.dso.PluginUtil;
import org.noear.luffy.utils.StringUtils;
import org.noear.luffy.utils.TextUtils;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;

public class InitUtil {
    public static DbContext db() {
        return DbUtil.db();
    }

    public static void tryInitDb() {
        try {
            InitUtil.do_initDb();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void do_initDbTable(String sql) throws Exception {
        InitUtil.db().exe(sql, new Object[0]);
    }

    private static void do_initDb() throws Exception {
        int num = InitUtil.db().getMetaData().getTableAll().size();
        if (num >= 8) {
            return;
        }
        InitUtil.do_initDbTable(" CREATE TABLE IF NOT EXISTS `a_config` (\n  `cfg_id` int NOT NULL AUTO_INCREMENT COMMENT '\u914d\u7f6eID',\n  `tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '\u5206\u7ec4\u6807\u7b7e',\n  `label` varchar(100) NOT NULL DEFAULT '' COMMENT '\u6807\u8bb0',\n  `name` varchar(100) NOT NULL COMMENT '\u540d\u79f0',\n  `value` varchar(999) NOT NULL DEFAULT '' COMMENT '\u503c',\n  `note` varchar(100) NOT NULL DEFAULT '' COMMENT '\u5907\u6ce8',\n  `edit_type` varchar(40) DEFAULT NULL COMMENT '\u7f16\u8f91\u7c7b\u578b',\n  `edit_placeholder` varchar(100) DEFAULT NULL COMMENT '\u7f16\u8f91\u63d0\u793a',\n  `is_disabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u7981\u6b62\u4f7f\u7528',\n  `is_exclude` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u6392\u9664\u5bfc\u5165',\n  `is_modified` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u53ef\u4fee\u6539\u7684\uff08\u7ec8\u7aef\u7528\u6237\uff09',\n  `create_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u6700\u540e\u66f4\u65b0\u65f6\u95f4',\n  PRIMARY KEY (`cfg_id`),\n  UNIQUE KEY `IX_a_config__key` (`name`) USING BTREE,\n  KEY `IX_a_config__tag` (`tag`) USING BTREE,\n  KEY `IX_a_config__label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u914d\u7f6e\u8868' ");
        InitUtil.do_initDbTable(" CREATE TABLE IF NOT EXISTS `a_file` (\n  `file_id` int NOT NULL AUTO_INCREMENT COMMENT '\u6587\u4ef6ID',\n  `tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '\u5206\u7ec4\u6751\u7b7e',\n  `label` varchar(100) NOT NULL DEFAULT '' COMMENT '\u6807\u8bb0',\n  `path` varchar(100) NOT NULL COMMENT '\u6587\u4ef6\u8def\u5f84',\n  `rank` int NOT NULL DEFAULT '0' COMMENT '\u6392\u5217\uff08\u5c0f\u7684\u6392\u524d\uff09',\n  `is_staticize` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u9759\u6001',\n  `is_editable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '\u662f\u5426\u53ef\u7f16\u8f91',\n  `is_disabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u7981\u7528',\n  `is_exclude` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u6392\u9664\u5bfc\u5165',\n  `link_to` varchar(100) DEFAULT NULL COMMENT '\u8fde\u63a5\u5230',\n  `edit_mode` varchar(40) NOT NULL DEFAULT '' COMMENT '\u7f16\u8f91\u6a21\u5f0f',\n  `content_type` varchar(60) NOT NULL DEFAULT '' COMMENT '\u5185\u5bb9\u7c7b\u578b',\n  `content` longtext COMMENT '\u5185\u5bb9',\n  `note` varchar(99) DEFAULT '' COMMENT '\u5907\u6ce8',\n  `plan_state` int NOT NULL DEFAULT '0' COMMENT '\u8ba1\u5212\u72b6\u6001',\n  `plan_begin_time` datetime DEFAULT NULL COMMENT '\u8ba1\u5212\u5f00\u59cb\u6267\u884c\u65f6\u95f4',\n  `plan_last_time` datetime DEFAULT NULL COMMENT '\u8ba1\u5212\u6700\u540e\u6267\u884c\u65f6\u95f4',\n  `plan_last_timespan` bigint NOT NULL DEFAULT '0' COMMENT '\u8ba1\u5212\u6700\u540e\u6267\u884c\u65f6\u95f4\u957f\u5ea6',\n  `plan_interval` varchar(200) NOT NULL DEFAULT '' COMMENT '\u8ba1\u5212\u6267\u884c\u95f4\u9694',\n  `plan_max` int NOT NULL DEFAULT '0' COMMENT '\u8ba1\u5212\u6267\u884c\u6700\u591a\u6b21\u6570',\n  `plan_count` int NOT NULL DEFAULT '0' COMMENT '\u8ba1\u5212\u6267\u884c\u7d2f\u8ba1\u6b21\u6570',\n  `create_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u66f4\u65b0\u65f6\u95f4',\n  PRIMARY KEY (`file_id`),\n  UNIQUE KEY `IX_a_file__key` (`path`) USING BTREE,\n  KEY `IX_a_file__tag` (`tag`) USING BTREE,\n  KEY `IX_a_file__label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u6587\u4ef6\u8868' ");
        InitUtil.do_initDbTable(" CREATE TABLE IF NOT EXISTS `a_image` (\n  `img_id` bigint NOT NULL AUTO_INCREMENT COMMENT '\u56fe\u7247ID',\n  `tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '\u5206\u7ec4\u6807\u7b7e',\n  `label` varchar(100) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e',\n  `path` varchar(100) NOT NULL COMMENT '\u6587\u4ef6\u8def\u5f84',\n  `content_type` varchar(100) NOT NULL COMMENT '\u5185\u5bb9\u7c7b\u578b',\n  `data` longtext COMMENT '\u6570\u636e',\n  `data_size` bigint NOT NULL DEFAULT '0' COMMENT '\u6570\u636e\u957f\u5ea6',\n  `data_md5` varchar(40) DEFAULT NULL COMMENT '\u6570\u636eMD5\u503c',\n  `note` varchar(100) DEFAULT NULL COMMENT '\u5907\u6ce8',\n  `create_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u6700\u540e\u66f4\u65b0\u65f6\u95f4',\n  PRIMARY KEY (`img_id`),\n  UNIQUE KEY `IX_a_image__key` (`path`) USING BTREE,\n  KEY `IX_a_image__tag` (`tag`) USING BTREE,\n  KEY `IX_a_image__label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u56fe\u7247\u8868' ");
        InitUtil.do_initDbTable(" CREATE TABLE IF NOT EXISTS `a_log` (\n  `log_id` bigint NOT NULL AUTO_INCREMENT,\n  `level` int NOT NULL DEFAULT '0' COMMENT '\u7b49\u7ea7',\n  `tag` varchar(100) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e',\n  `tag1` varchar(100) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e1',\n  `tag2` varchar(100) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e2',\n  `tag3` varchar(100) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e3',\n  `tag4` varchar(100) NOT NULL DEFAULT '' COMMENT '\u6807\u7b7e4',\n  `summary` varchar(1000) NOT NULL DEFAULT '' COMMENT '\u6458\u8981',\n  `content` longtext COMMENT '\u5185\u5bb9',\n  `log_date` int NOT NULL DEFAULT '0' COMMENT '\u8bb0\u5f55\u65e5\u671f',\n  `log_fulltime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '\u8bb0\u5f55\u5b8c\u6574\u65f6\u95f4',\n  `from` varchar(100) DEFAULT NULL COMMENT '\u6765\u6e90',\n  PRIMARY KEY (`log_id`),\n  KEY `IX_a_log__date` (`log_date`) USING BTREE,\n  KEY `IX_a_log__tag` (`tag`) USING BTREE,\n  KEY `IX_a_log__tag1` (`tag1`) USING BTREE,\n  KEY `IX_a_log__tag2` (`tag2`) USING BTREE,\n  KEY `IX_a_log__tag3` (`tag3`) USING BTREE,\n  KEY `IX_a_log__tag4` (`tag4`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u65e5\u5fd7\u8868' ");
        InitUtil.do_initDbTable(" CREATE TABLE IF NOT EXISTS `a_menu` (\n  `menu_id` int NOT NULL AUTO_INCREMENT COMMENT '\u83dc\u5355ID',\n  `pid` int NOT NULL DEFAULT '0' COMMENT '\u7236\u7ea7ID',\n  `tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '\u5206\u7ec4\u6807\u7b7e',\n  `label` varchar(100) DEFAULT '' COMMENT '\u5206\u7c7b\uff1a\u4e3b\u83dc\u5355\u3001\u9876\u90e8\u83dc\u5355\u3001\u5e95\u90e8\u83dc\u5355\u7b49',\n  `txt` varchar(100) DEFAULT NULL COMMENT '\u6587\u672c\u5185\u5bb9',\n  `url` varchar(512) DEFAULT NULL COMMENT '\u94fe\u63a5\u7684url',\n  `target` varchar(32) DEFAULT NULL COMMENT '\u6253\u5f00\u7684\u65b9\u5f0f',\n  `level` int NOT NULL DEFAULT '0' COMMENT '\u7ea7\u522b',\n  `icon` varchar(64) DEFAULT NULL COMMENT '\u83dc\u5355\u7684icon',\n  `flag` varchar(32) DEFAULT NULL COMMENT '\u83dc\u5355\u6807\u8bc6',\n  `order_number` int DEFAULT '0' COMMENT '\u6392\u5e8f\u5b57\u6bb5',\n  `rel_table` varchar(40) DEFAULT NULL COMMENT '\u8be5\u83dc\u5355\u662f\u5426\u548c\u5176\u4ed6\u8868\u5173\u8054',\n  `rel_id` bigint unsigned DEFAULT NULL COMMENT '\u5173\u8054\u7684\u5177\u4f53\u6570\u636eid',\n  `is_disabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u7981\u7528',\n  `is_exclude` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u6392\u9664\u5bfc\u5165',\n  `create_fulltime` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '\u4fee\u6539\u65f6\u95f4',\n  PRIMARY KEY (`menu_id`),\n  KEY `IX_a_menu__order_number` (`order_number`) USING BTREE,\n  KEY `IX_a_menu__tag` (`tag`) USING BTREE,\n  KEY `IX_a_menu__label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u83dc\u5355\u8868' ");
        InitUtil.do_initDbTable(" CREATE TABLE IF NOT EXISTS `a_message` (\n  `msg_id` bigint NOT NULL AUTO_INCREMENT COMMENT '\u6d88\u606fID',\n  `topic` varchar(100) NOT NULL DEFAULT '' COMMENT '\u4e3b\u9898',\n  `topic_source` varchar(100) DEFAULT NULL COMMENT '\u539f\u59cb\u4e3b\u9898',\n  `content` varchar(4000) NOT NULL COMMENT '\u6d88\u606f\u5185\u5bb9',\n  `state` int NOT NULL DEFAULT '0' COMMENT '\u72b6\u6001\uff08-2\u65e0\u6d3e\u53d1\u5bf9\u8c61 ; -1:\u5ffd\u7565\uff1b0:\u672a\u5904\u7406\uff1b1\u5904\u7406\u4e2d\uff1b2\u5df2\u5b8c\u6210\uff1b3\u6d3e\u53d1\u8d85\u6b21\u6570\uff09',\n  `dist_count` int NOT NULL DEFAULT '0' COMMENT '\u6d3e\u53d1\u7d2f\u8bb0\u6b21\u6570',\n  `dist_ntime` bigint NOT NULL DEFAULT '0' COMMENT '\u4e0b\u6b21\u6d3e\u53d1\u65f6\u95f4',\n  `log_date` int NOT NULL DEFAULT '0' COMMENT '\u8bb0\u5f55\u65e5\u671f\uff08yyyyMMdd\uff09',\n  `log_fulltime` datetime NOT NULL COMMENT '\u8bb0\u5f55\u65f6\u95f4',\n  PRIMARY KEY (`msg_id`),\n  KEY `IX_a_message__topic` (`topic`) USING BTREE,\n  KEY `IX_a_message__state` (`state`) USING BTREE,\n  KEY `IX_a_message__dist_ntime` (`dist_ntime`) USING BTREE,\n  KEY `IX_a_message__dist_count` (`dist_count`) USING BTREE,\n  KEY `IX_a_message__log_date` (`log_date`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u6d88\u606f\u8868' ");
        InitUtil.do_initDbTable(" CREATE TABLE IF NOT EXISTS `a_message_distribution` (\n  `dist_id` bigint NOT NULL AUTO_INCREMENT COMMENT '\u5206\u53d1ID',\n  `msg_id` bigint NOT NULL COMMENT '\u5f85\u5206\u53d1\u7684\u6d88\u606fID',\n  `file_id` int NOT NULL DEFAULT '0',\n  `receive_url` varchar(200) NOT NULL DEFAULT '',\n  `receive_way` int NOT NULL DEFAULT '0' COMMENT '\u63a5\u6536\u65b9\u5f0f\uff080HTTP\u5f02\u6b65\u7b49\u5f85\uff1b1HTTP\u540c\u6b65\u7b49\u5f85\uff1b2HTTP\u5f02\u6b65\u4e0d\u7b49\u5f85\uff09',\n  `duration` int NOT NULL DEFAULT '0' COMMENT '\u6d88\u8017\u65f6\u957f\uff08s\uff09',\n  `state` int NOT NULL DEFAULT '0' COMMENT '\u5206\u53d1\u72b6\u6001\uff08-1\u5ffd\u7565\uff1b0\u5f00\u59cb\uff1b1\u5931\u8d25\uff1b2\u6210\u529f\uff1b\uff09',\n  `log_date` int NOT NULL DEFAULT '0' COMMENT '\u5206\u53d1\u65e5\u671f\uff08yyyyMMdd\uff09',\n  `log_fulltime` datetime NOT NULL COMMENT '\u5206\u53d1\u65f6\u95f4',\n  PRIMARY KEY (`dist_id`),\n  UNIQUE KEY `IX_a_message_distribution__key` (`msg_id`,`file_id`) USING BTREE,\n  KEY `IX_a_message_distribution__date` (`log_date`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u6d88\u606f\u6d3e\u53d1\u8868' ");
        InitUtil.do_initDbTable(" CREATE TABLE IF NOT EXISTS `a_plugin` (\n  `plugin_id` int NOT NULL AUTO_INCREMENT COMMENT '\u63d2\u4ef6ID',\n  `plugin_tag` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '\u63d2\u4ef6\u6807\u7b7e',\n  `tag` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',\n  `label` varchar(100) NOT NULL DEFAULT '' COMMENT '\u6807\u8bb0',\n  `category` varchar(40) NOT NULL DEFAULT '' COMMENT '\u5206\u7c7b\uff08\u9884\u7559\uff09',\n  `name` varchar(40) NOT NULL COMMENT '\u540d\u79f0',\n  `author` varchar(40) NOT NULL COMMENT '\u4f5c\u8005',\n  `contacts` varchar(99) DEFAULT NULL COMMENT '\u8054\u7cfb\u65b9\u5f0f',\n  `ver_code` int NOT NULL DEFAULT '0' COMMENT '\u7248\u672c\u4ee3\u53f7',\n  `ver_name` varchar(40) NOT NULL COMMENT '\u7248\u672c\u540d\u79f0',\n  `description` varchar(255) DEFAULT NULL COMMENT '\u63cf\u8ff0',\n  `thumbnail` varchar(255) DEFAULT NULL COMMENT '\u7f29\u7565\u56fe',\n  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '\u5730\u5740',\n  `is_installed` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u5df2\u5b89\u88c5\uff08\u76f8\u5bf9\u4e8e\u81ea\u5df1\uff09',\n  `is_approved` tinyint(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u5ba1\u6838\u901a\u8fc7',\n  `num_downloads` int NOT NULL DEFAULT '0' COMMENT '\u4e0b\u8f7d\u91cf',\n  `create_fulltime` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '\u521b\u5efa\u65f6\u95f4',\n  `update_fulltime` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '\u6700\u540e\u66f4\u65b0\u65f6\u95f4',\n  PRIMARY KEY (`plugin_id`),\n  UNIQUE KEY `IX_a_plugin__key` (`plugin_tag`) USING BTREE,\n  KEY `IX_a_plugin__tag` (`tag`) USING BTREE,\n  KEY `IX_a_plugin__category` (`category`) USING BTREE,\n  KEY `IX_a_plugin__label` (`label`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='jt-\u63d2\u4ef6\u8868' ");
        System.out.println("Complete table structure");
    }

    public static void tryInitNode(SolonApp app) {
        String node = app.cfg().get("luffy.node");
        if (TextUtils.isEmpty((String)node)) {
            node = (String)app.cfg().argx().get((Object)"node");
        }
        if (!TextUtils.isEmpty((String)node)) {
            app.cfg().argx().put("node", (Object)node);
            app.cfg().put((Object)"luffy.node", (Object)node);
            try {
                String addr = JtUtil.g.localAddr();
                DbApi.cfgSetNote(node, addr, "cluster.node");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void tryInitCore(SolonApp app) {
        try {
            InitUtil.do_initCore(app);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void do_initCore(SolonApp app) throws Exception {
        if (PluginUtil.install("_core.noear")) {
            ((DbTableQuery)InitUtil.db().table("a_config").set("value", (Object)"Iv1H81dI2ZNzDS2n").where("name=?", new Object[]{"_frm_admin_pwd"})).update();
            ((DbTableQuery)InitUtil.db().table("a_config").set("value", (Object)"0").where("name=?", new Object[]{"_frm_enable_dev"})).update();
            ((DbTableQuery)InitUtil.db().table("a_file").set("link_to", (Object)"").where("path='/'", new Object[0])).update();
        }
        System.out.println("Complete _core loading");
    }

    public static String tryInitExtend(NvMap xarg) {
        String extend = (String)xarg.get((Object)"extend");
        if (extend == null) {
            extend = InitUtil.do_buildRoot();
        }
        return extend;
    }

    private static String do_buildRoot() {
        int idx;
        URL temp = Utils.getResource((String)"");
        if (temp == null) {
            return null;
        }
        String uri = temp.toString();
        if (uri.startsWith("file:/")) {
            idx = uri.lastIndexOf("/target/");
            uri = uri.substring(5, idx + 8);
        } else {
            idx = uri.indexOf("jar!/");
            idx = uri.lastIndexOf("/", idx) + 1;
            uri = uri.substring(9, idx);
        }
        uri = uri + "jt_ext" + "/";
        File dir = new File(uri);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return uri;
    }

    public static void trySaveConfig(String extend, NvMap map) throws Exception {
        File file = new File(extend + "_db.properties");
        file.delete();
        file.createNewFile();
        StringBuilder sb = StringUtils.borrowBuilder();
        map.forEach((k, v) -> {
            if ("center".equals(k) || "node".equals(k)) {
                sb.append("luffy").append(".");
            } else {
                sb.append("luffy.db").append(".");
            }
            sb.append((String)k).append("=").append((String)v).append("\r\n");
        });
        FileWriter fw = new FileWriter(file);
        fw.write(StringUtils.releaseBuilder((StringBuilder)sb));
        fw.flush();
        fw.close();
    }
}

