/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.dso;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.noear.luffy.Config;
import org.noear.luffy.Luffy;
import org.noear.luffy.dso.CallUtil;
import org.noear.luffy.dso.DbUtil;
import org.noear.luffy.dso.InitUtil;
import org.noear.luffy.dso.JtUtil;
import org.noear.luffy.dso.LogLevel;
import org.noear.luffy.dso.LogUtil;
import org.noear.luffy.dso.RouteHelper;
import org.noear.luffy.dso.TaskRunner;
import org.noear.luffy.event.http.AppHandler;
import org.noear.luffy.event.http.FrmInterceptor;
import org.noear.luffy.event.http.ImgHandler;
import org.noear.luffy.event.http.SufHandler;
import org.noear.luffy.task.IJtTaskRunner;
import org.noear.luffy.task.TaskFactory;
import org.noear.luffy.utils.ExceptionUtils;
import org.noear.luffy.utils.IOUtils;
import org.noear.luffy.utils.TextUtils;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.wood.WoodConfig;

public class AppUtil {
    public static void init(SolonApp app, boolean initDb) {
        if (initDb) {
            DbUtil.setDefDb(app.cfg().getMap("luffy.db"));
        }
        InitUtil.tryInitDb();
        InitUtil.tryInitCore(app);
        InitUtil.tryInitNode(app);
    }

    public static void runAsInit(SolonApp app, String extend) {
        URL temp = ResourceUtil.getResource((String)"setup.htm");
        String html = null;
        try {
            html = IOUtils.toString((InputStream)temp.openStream(), (String)"utf-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String node2 = (String)app.cfg().argx().get("node");
        String html2 = html.trim();
        app.post("/setup.jsx", ctx -> {
            if (node2 != null && node2.length() > 30) {
                ctx.paramMap().put("node", (Object)node2);
            } else {
                ctx.paramMap().put("node", (Object)JtUtil.g.guid());
            }
            Map paramMap = ctx.paramMap().toValueMap();
            DbUtil.setDefDb(paramMap);
            try {
                DbUtil.db().sql("SHOW TABLES", new Object[0]).execute();
                InitUtil.trySaveConfig(extend, paramMap);
                app.cfg().argx().putAll(paramMap);
                AppUtil.init(app, false);
                String _usr = JtUtil.g.cfgGet("_frm_admin_user");
                String _pwd = JtUtil.g.cfgGet("_frm_admin_pwd");
                String _token = JtUtil.g.sha1(_usr + '#' + _pwd, "UTF-16LE").toUpperCase();
                ONode rst = new ONode();
                rst.set("code", (Object)1);
                rst.set("token", (Object)_token);
                rst.set("home", Solon.cfg().argx().get("home"));
                ctx.outputAsJson(rst.toJson());
                Solon.app().router().clear();
                AppUtil.runAsWork(Solon.app());
            }
            catch (Throwable ex) {
                ctx.outputAsJson(new ONode().set("code", (Object)0).set("msg", (Object)ExceptionUtils.getString((Throwable)ex)).toJson());
            }
        });
        app.get("/", ctx -> ctx.outputAsHtml(html2));
        app.get("/**", ctx -> ctx.redirect("/"));
    }

    public static void runAsWork(SolonApp app) {
        String sss = (String)app.cfg().argx().get("sss");
        app.sharedAdd("db", (Object)DbUtil.db());
        app.sharedAdd("cache", (Object)DbUtil.cache);
        app.sharedAdd("localCache", (Object)DbUtil.cache);
        if (TextUtils.isEmpty((String)sss) || sss.indexOf("web") >= 0) {
            RouteHelper.reset();
            AppUtil.do_runWeb(app);
        }
        if (TextUtils.isEmpty((String)sss) || sss.indexOf("sev") >= 0) {
            AppUtil.do_runSev(app);
        }
        AppUtil.do_woodTrack();
        Luffy.onLoad();
        CallUtil.callLabel(null, (String)"hook.start", (boolean)false, null);
    }

    private static void do_runWeb(SolonApp app) {
        app.routerInterceptor((RouterInterceptor)FrmInterceptor.g());
        app.get(Config.frm_root_img + "**", (Handler)new ImgHandler());
        app.http("**", (Handler)AppHandler.g());
        app.handler().prev((Handler)SufHandler.g());
    }

    private static void do_runSev(SolonApp app) {
        TaskFactory.run((IJtTaskRunner)TaskRunner.g);
    }

    private static void do_woodTrack() {
        WoodConfig.onException((cmd, ex) -> {
            if (cmd.text.indexOf("a_log") < 0 && cmd.isLog >= 0) {
                System.out.println(cmd.text);
                LogUtil.log((String)"wood", (String)"err_log", (LogLevel)LogLevel.ERROR, (String)"\u51fa\u9519", (String)(cmd.text + "<br/><br/>" + ExceptionUtils.getString((Throwable)ex)));
            }
        });
        WoodConfig.onExecuteAft(cmd -> {
            if (cmd.isLog < 0) {
                return;
            }
            if (cmd.timespan() > 1000L) {
                LogUtil.log((String)"wood", (String)"slow_log", (LogLevel)LogLevel.WARN, (String)(cmd.timespan() + "ms"), (String)cmd.text);
            }
        });
    }
}

