/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.dso;

import java.net.URLEncoder;
import java.util.Date;
import org.noear.luffy.model.AImageModel;
import org.noear.luffy.utils.Base64Utils;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;

public class AImageHandler {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final Date app_runtime = new Date();

    public static void handle(Context context, AImageModel file) throws Exception {
        String mime;
        String path = context.path();
        context.setHandled(true);
        String modified_since = context.header("If-Modified-Since");
        String modified_now = app_runtime.toString();
        if (modified_since != null && modified_since.equals(modified_now)) {
            context.headerSet(CACHE_CONTROL, "max-age=6000");
            context.headerSet(LAST_MODIFIED, modified_now);
            context.contentType(file.content_type);
            context.charset("utf-8");
            context.status(304);
            return;
        }
        int idx = path.lastIndexOf(".");
        if (idx > 0 && (mime = file.content_type) != null) {
            context.headerSet(CACHE_CONTROL, "max-age=6000");
            context.headerSet(LAST_MODIFIED, app_runtime.toString());
            context.contentType(file.content_type);
            context.charset("utf-8");
            if (file.note != null) {
                String fileName = URLEncoder.encode(file.note, Solon.encoding());
                context.headerSet("Content-Disposition", "filename=\"" + fileName + "\"");
            }
        }
        byte[] data = Base64Utils.decodeByte((String)file.data);
        context.status(200);
        context.outputStream().write(data);
        context.outputStream().flush();
    }
}

