/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.dso;

import java.io.File;
import java.io.FileOutputStream;
import okhttp3.Response;
import org.noear.luffy.utils.Base64Utils;
import org.noear.luffy.utils.EncryptUtils;
import org.noear.luffy.utils.HttpUtils;
import org.noear.luffy.utils.IOUtils;
import org.noear.luffy.utils.TextUtils;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.Plugin;

public class JarUtil {
    public static boolean loadJar(String path, String data64, String data_md5, String xPlugin) throws Exception {
        String extend = (String)Solon.cfg().argx().get((Object)"extend");
        int idx = path.lastIndexOf(47);
        String filename = extend + path.substring(idx);
        if (path.indexOf("://") < 0) {
            byte[] data = Base64Utils.decodeByte((String)data64);
            if (TextUtils.isEmpty((String)data_md5)) {
                data_md5 = EncryptUtils.md5Bytes((byte[])data);
            }
            if (!JarUtil.doCehckMd5(filename, data_md5)) {
                return false;
            }
            return JarUtil.doLoadJar(filename, data, data_md5, xPlugin);
        }
        if (TextUtils.isEmpty((String)data_md5)) {
            return false;
        }
        if (!JarUtil.doCehckMd5(filename, data_md5)) {
            return false;
        }
        try (Response res = HttpUtils.http((String)path).asLongHttp().exec("GET");){
            if (!res.isSuccessful()) {
                boolean bl = false;
                return bl;
            }
            byte[] data = res.body().bytes();
            boolean bl = JarUtil.doLoadJar(filename, data, data_md5, xPlugin);
            return bl;
        }
    }

    private static boolean doCehckMd5(String filename, String data_md5) throws Exception {
        File file = new File(filename);
        if (file.exists()) {
            byte[] data2 = IOUtils.getFileBytes((File)file);
            String md2 = EncryptUtils.md5Bytes((byte[])data2);
            if (data_md5 != null && data_md5.equalsIgnoreCase(md2)) {
                return false;
            }
        }
        return true;
    }

    private static boolean doLoadJar(String filename, byte[] data, String data_md5, String xPlugin) throws Exception {
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        FileOutputStream fw = new FileOutputStream(file);
        fw.write(data);
        fw.close();
        try {
            Plugin p1;
            ExtendLoader.unloadJar((File)file);
            ExtendLoader.loadJar((File)file);
            if (!TextUtils.isEmpty((String)xPlugin) && (p1 = (Plugin)JarUtil.newInstance(xPlugin)) != null) {
                Solon.global().plug(p1);
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static <T> T newInstance(String className) {
        return (T)Utils.newInstance((String)className);
    }
}

