/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.minio.service;

import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import java.io.InputStream;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.core.handle.Result;

public class CloudFileServiceMinioImpl
implements CloudFileService {
    private final String bucketDef;
    private final String endpoint;
    private final String regionId;
    private final String accessKey;
    private final String secretKey;
    private final MinioClient client;

    public MinioClient getClient() {
        return this.client;
    }

    public CloudFileServiceMinioImpl(CloudProps cloudProps) {
        this(cloudProps.getFileEndpoint(), cloudProps.getFileRegionId(), cloudProps.getFileBucket(), cloudProps.getFileAccessKey(), cloudProps.getFileSecretKey());
    }

    public CloudFileServiceMinioImpl(String endpoint, String regionId, String bucket, String accessKey, String secretKey) {
        this.endpoint = endpoint;
        this.regionId = regionId;
        this.bucketDef = bucket;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.client = MinioClient.builder().endpoint(this.endpoint).region(this.regionId).credentials(this.accessKey, this.secretKey).build();
    }

    public Media get(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            GetObjectResponse obj = this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(key)).build());
            return new Media((InputStream)obj, obj.headers().get("Content-Type"));
        }
        catch (Exception exception) {
            throw new CloudFileException((Throwable)exception);
        }
    }

    public Result<?> put(String bucket, String key, Media media) throws CloudFileException {
        String streamMime;
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        if (Utils.isEmpty((String)(streamMime = media.contentType()))) {
            streamMime = "text/plain; charset=utf-8";
        }
        try {
            ObjectWriteResponse response = this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(key)).stream(media.body(), media.contentSize(), -1L).contentType(streamMime).build());
            return Result.succeed((Object)response);
        }
        catch (Exception exception) {
            throw new CloudFileException((Throwable)exception);
        }
    }

    public Result<?> delete(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(key)).build());
            return Result.succeed();
        }
        catch (Exception exception) {
            throw new CloudFileException((Throwable)exception);
        }
    }
}

