/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.minio.service;

import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import java.io.InputStream;
import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.extend.minio.MinioProps;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.core.handle.Result;

public class CloudFileServiceMinioImp
implements CloudFileService {
    private static CloudFileServiceMinioImp instance;
    protected final String bucketDef;
    protected final String endpoint;
    protected final String regionId;
    protected final String accessKey;
    protected final String secretKey;
    protected final MinioClient minioClient;

    public static synchronized CloudFileServiceMinioImp getInstance() {
        if (instance == null) {
            instance = new CloudFileServiceMinioImp();
        }
        return instance;
    }

    private CloudFileServiceMinioImp() {
        this(MinioProps.INSTANCE.getFileEndpoint(), MinioProps.INSTANCE.getFileRegionId(), MinioProps.INSTANCE.getFileBucket(), MinioProps.INSTANCE.getFileAccessKey(), MinioProps.INSTANCE.getFileSecretKey());
    }

    public CloudFileServiceMinioImp(Properties properties) {
        this(properties.getProperty("endpoint"), properties.getProperty("regionId"), properties.getProperty("bucket"), properties.getProperty("accessKey"), properties.getProperty("secretKey"));
    }

    public CloudFileServiceMinioImp(String endpoint, String regionId, String bucket, String accessKey, String secretKey) {
        this.endpoint = endpoint;
        this.regionId = regionId;
        this.bucketDef = bucket;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.minioClient = MinioClient.builder().endpoint(this.endpoint).region(this.regionId).credentials(this.accessKey, this.secretKey).build();
    }

    public Media get(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            GetObjectResponse obj = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(key)).build());
            return new Media((InputStream)obj, obj.headers().get("Content-Type"));
        }
        catch (Exception exception) {
            throw new CloudFileException((Throwable)exception);
        }
    }

    public Result<?> put(String bucket, String key, Media media) throws CloudFileException {
        String streamMime;
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        if (Utils.isEmpty((String)(streamMime = media.contentType()))) {
            streamMime = "text/plain; charset=utf-8";
        }
        try {
            ObjectWriteResponse response = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(key)).stream(media.body(), (long)media.body().available(), -1L).contentType(streamMime).build());
            return Result.succeed((Object)response);
        }
        catch (Exception exception) {
            throw new CloudFileException((Throwable)exception);
        }
    }

    public Result<?> delete(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(key)).build());
            return Result.succeed();
        }
        catch (Exception exception) {
            throw new CloudFileException((Throwable)exception);
        }
    }

    public MinioClient getMinio() {
        return this.minioClient;
    }
}

