/*
 * Decompiled with CFR 0.152.
 */
package org.noear.mlog;

import org.noear.mlog.ILoggerFactory;
import org.noear.mlog.Level;
import org.noear.mlog.Logger;
import org.noear.mlog.LoggerSimple;

public class LoggerFactory {
    private static volatile Level level = Level.TRACE;
    private static ILoggerFactory factory = name -> new LoggerSimple(name);

    public static void setLevel(Level level) {
        LoggerFactory.level = level;
    }

    public static Level getLevel() {
        return level;
    }

    public static ILoggerFactory getFactory() {
        return factory;
    }

    public static void setFactory(ILoggerFactory factory) {
        LoggerFactory.factory = factory;
    }

    public static Logger get(String name) {
        return factory.getLogger(name);
    }

    public static Logger get(Class<?> clz) {
        return factory.getLogger(clz);
    }

    static {
        try {
            ILoggerFactory implObj;
            String implName = "org.noear.mlog.impl.ILoggerFactoryImpl";
            Class<?> implClz = null;
            if (implClz == null) {
                implClz = ClassLoader.getSystemClassLoader().loadClass(implName);
            }
            if (implClz == null) {
                implClz = LoggerFactory.class.getClassLoader().loadClass(implName);
            }
            if (implClz != null && (implObj = (ILoggerFactory)implClz.newInstance()) != null) {
                LoggerFactory.setFactory(implObj);
            }
        }
        catch (Throwable ex) {
            System.err.println("[warn] org.noear.mlog.ILoggerFactoryImpl load failed");
        }
    }
}

