/*
 * Decompiled with CFR 0.152.
 */
package org.noear.mlog;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.noear.mlog.Level;
import org.noear.mlog.Logger;
import org.noear.mlog.Marker;
import org.noear.mlog.utils.LogFormatter;

public class LoggerSimple
implements Logger {
    protected String name;
    protected Class<?> clz;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public LoggerSimple(String name) {
        this.name = name;
    }

    public LoggerSimple(Class<?> clz) {
        this.name = clz.getName();
        this.clz = clz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void trace(Object content) {
        this.traceDo(null, content, null, null);
    }

    @Override
    public void trace(String format, Object ... args) {
        this.traceDo(null, null, format, args);
    }

    @Override
    public void trace(Marker marker, Object content) {
        this.traceDo(marker, content, null, null);
    }

    @Override
    public void trace(Marker marker, String format, Object ... args) {
        this.traceDo(marker, null, format, args);
    }

    private void traceDo(Marker marker, Object content, String format, Object[] args) {
        if (this.isTraceEnabled()) {
            this.appendDo(Level.TRACE, marker, content, format, args);
        }
    }

    @Override
    public void debug(Object content) {
        this.debugDo(null, content, null, null);
    }

    @Override
    public void debug(String format, Object ... args) {
        this.debugDo(null, null, format, args);
    }

    @Override
    public void debug(Marker marker, Object content) {
        this.debugDo(marker, content, null, null);
    }

    @Override
    public void debug(Marker marker, String format, Object ... args) {
        this.debugDo(marker, null, format, args);
    }

    private void debugDo(Marker marker, Object content, String format, Object[] args) {
        if (this.isDebugEnabled()) {
            this.appendDo(Level.DEBUG, marker, content, format, args);
        }
    }

    @Override
    public void info(Object content) {
        this.infoDo(null, content, null, null);
    }

    @Override
    public void info(String format, Object ... args) {
        this.infoDo(null, null, format, args);
    }

    @Override
    public void info(Marker marker, Object content) {
        this.infoDo(marker, content, null, null);
    }

    @Override
    public void info(Marker marker, String format, Object ... args) {
        this.infoDo(marker, null, format, args);
    }

    private void infoDo(Marker marker, Object content, String format, Object[] args) {
        if (this.isInfoEnabled()) {
            this.appendDo(Level.INFO, marker, content, format, args);
        }
    }

    @Override
    public void warn(Object content) {
        this.warnDo(null, content, null, null);
    }

    @Override
    public void warn(String format, Object ... args) {
        this.warnDo(null, null, format, args);
    }

    @Override
    public void warn(Marker marker, Object content) {
        this.warnDo(marker, content, null, null);
    }

    @Override
    public void warn(Marker marker, String format, Object ... args) {
        this.warnDo(marker, null, format, args);
    }

    private void warnDo(Marker marker, Object content, String format, Object[] args) {
        if (this.isWarnEnabled()) {
            this.appendDo(Level.WARN, marker, content, format, args);
        }
    }

    @Override
    public void error(Object content) {
        this.errorDo(null, content, null, null);
    }

    @Override
    public void error(String format, Object ... args) {
        this.errorDo(null, null, format, args);
    }

    @Override
    public void error(Marker marker, Object content) {
        this.errorDo(marker, content, null, null);
    }

    @Override
    public void error(Marker marker, String format, Object ... args) {
        this.errorDo(marker, null, format, args);
    }

    private void errorDo(Marker marker, Object content, String format, Object[] args) {
        if (this.isErrorEnabled()) {
            this.appendDo(Level.ERROR, marker, content, format, args);
        }
    }

    protected void appendDo(Level level, Marker marker, Object content, String format, Object[] args) {
        if (format != null) {
            content = args != null && args.length > 0 ? LogFormatter.arrayFormat(format, args).getMessage() : format;
        }
        this.write(level, marker, content);
    }

    public void write(Level level, Marker marker, Object content) {
        String text = null;
        text = marker == null ? String.format("%s [%s] :: %s", this.sdf.format(new Date()), level.name(), content) : String.format("%s [%s] %s:: %s", this.sdf.format(new Date()), level.name(), marker.formatAsString(), content);
        System.out.println(text);
    }
}

