/*
 * Decompiled with CFR 0.152.
 */
package org.noear.mlog;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.noear.mlog.Level;
import org.noear.mlog.Logger;
import org.noear.mlog.Metainfo;
import org.noear.mlog.utils.LogFormatter;

public class LoggerSimple
implements Logger {
    protected String name;
    protected Class<?> clz;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public LoggerSimple(String name) {
        this.name = name;
    }

    public LoggerSimple(Class<?> clz) {
        this.name = clz.getName();
        this.clz = clz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void trace(Object content) {
        this.traceDo(null, content, null, null);
    }

    @Override
    public void trace(String format, Object ... args) {
        this.traceDo(null, null, format, args);
    }

    @Override
    public void trace(Metainfo metainfo, Object content) {
        this.traceDo(metainfo, content, null, null);
    }

    @Override
    public void trace(Metainfo metainfo, String format, Object ... args) {
        this.traceDo(metainfo, null, format, args);
    }

    private void traceDo(Metainfo metainfo, Object content, String format, Object[] args) {
        if (this.isTraceEnabled()) {
            this.appendDo(Level.TRACE, metainfo, content, format, args);
        }
    }

    @Override
    public void debug(Object content) {
        this.debugDo(null, content, null, null);
    }

    @Override
    public void debug(String format, Object ... args) {
        this.debugDo(null, null, format, args);
    }

    @Override
    public void debug(Metainfo metainfo, Object content) {
        this.debugDo(metainfo, content, null, null);
    }

    @Override
    public void debug(Metainfo metainfo, String format, Object ... args) {
        this.debugDo(metainfo, null, format, args);
    }

    private void debugDo(Metainfo metainfo, Object content, String format, Object[] args) {
        if (this.isDebugEnabled()) {
            this.appendDo(Level.DEBUG, metainfo, content, format, args);
        }
    }

    @Override
    public void info(Object content) {
        this.infoDo(null, content, null, null);
    }

    @Override
    public void info(String format, Object ... args) {
        this.infoDo(null, null, format, args);
    }

    @Override
    public void info(Metainfo metainfo, Object content) {
        this.infoDo(metainfo, content, null, null);
    }

    @Override
    public void info(Metainfo metainfo, String format, Object ... args) {
        this.infoDo(metainfo, null, format, args);
    }

    private void infoDo(Metainfo metainfo, Object content, String format, Object[] args) {
        if (this.isInfoEnabled()) {
            this.appendDo(Level.INFO, metainfo, content, format, args);
        }
    }

    @Override
    public void warn(Object content) {
        this.warnDo(null, content, null, null);
    }

    @Override
    public void warn(String format, Object ... args) {
        this.warnDo(null, null, format, args);
    }

    @Override
    public void warn(Metainfo metainfo, Object content) {
        this.warnDo(metainfo, content, null, null);
    }

    @Override
    public void warn(Metainfo metainfo, String format, Object ... args) {
        this.warnDo(metainfo, null, format, args);
    }

    private void warnDo(Metainfo metainfo, Object content, String format, Object[] args) {
        if (this.isWarnEnabled()) {
            this.appendDo(Level.WARN, metainfo, content, format, args);
        }
    }

    @Override
    public void error(Object content) {
        this.errorDo(null, content, null, null);
    }

    @Override
    public void error(String format, Object ... args) {
        this.errorDo(null, null, format, args);
    }

    @Override
    public void error(Metainfo metainfo, Object content) {
        this.errorDo(metainfo, content, null, null);
    }

    @Override
    public void error(Metainfo metainfo, String format, Object ... args) {
        this.errorDo(metainfo, null, format, args);
    }

    private void errorDo(Metainfo metainfo, Object content, String format, Object[] args) {
        if (this.isErrorEnabled()) {
            this.appendDo(Level.ERROR, metainfo, content, format, args);
        }
    }

    protected void appendDo(Level level, Metainfo metainfo, Object content, String format, Object[] args) {
        if (format != null) {
            content = args != null && args.length > 0 ? LogFormatter.arrayFormat(format, args).getMessage() : format;
        }
        this.write(level, metainfo, content);
    }

    public void write(Level level, Metainfo metainfo, Object content) {
        String text = null;
        text = metainfo == null ? String.format("%s [%s] :: %s", this.sdf.format(new Date()), level.name(), content) : String.format("%s [%s] %s:: %s", this.sdf.format(new Date()), level.name(), metainfo.toString(), content);
        System.out.println(text);
    }
}

