/*
 * Decompiled with CFR 0.152.
 */
package org.noear.mongox;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.noear.wood.DataItem;
import org.noear.wood.utils.StringUtils;

public class MongoX
implements AutoCloseable {
    MongoClient client;
    MongoDatabase database;

    public MongoX(Properties props, String schema) {
        this(props.getProperty("url"), schema);
    }

    public MongoX(String url, String schema) {
        if (StringUtils.isEmpty((String)schema)) {
            throw new IllegalArgumentException("MongoX: Missing schema(db) configuration");
        }
        this.client = MongoClients.create((String)url);
        this.database = this.client.getDatabase(schema);
    }

    public MongoCollection<Document> getCollection(String coll) {
        return this.database.getCollection(coll);
    }

    public <T> MongoCollection<T> getCollection(String coll, Class<T> clz) {
        return this.database.getCollection(coll, clz);
    }

    public void insertOne(Class<?> coll, Map<String, Object> data) {
        this.insertOne(coll.getSimpleName(), data);
    }

    public void insertOne(String coll, Map<String, Object> data) {
        MongoCollection<Document> collM = this.getCollection(coll);
        collM.insertOne((Object)new Document(data));
    }

    public void insertMany(Class<?> coll, List<Map<String, Object>> dataList) {
        this.insertMany(coll.getSimpleName(), dataList);
    }

    public void insertMany(String coll, List<Map<String, Object>> dataList) {
        MongoCollection<Document> collM = this.getCollection(coll);
        ArrayList<Document> list = new ArrayList<Document>();
        for (Map<String, Object> data : dataList) {
            list.add(new Document(data));
        }
        collM.insertMany(list);
    }

    public long updateOne(Class<?> coll, Map<String, Object> filter, Map<String, Object> data) {
        return this.updateOne(coll.getSimpleName(), filter, data);
    }

    public long updateOne(String coll, Map<String, Object> filter, Map<String, Object> data) {
        MongoCollection<Document> collM = this.getCollection(coll);
        Document newData = new Document();
        newData.put("$set", data);
        return collM.updateOne((Bson)new Document(filter), (Bson)newData).getModifiedCount();
    }

    public long updateMany(Class<?> coll, Map<String, Object> filter, Map<String, Object> data) {
        return this.updateMany(coll.getSimpleName(), filter, data);
    }

    public long updateMany(String coll, Map<String, Object> filter, Map<String, Object> data) {
        MongoCollection<Document> collM = this.getCollection(coll);
        Document newData = new Document();
        newData.put("$set", data);
        return collM.updateMany((Bson)new Document(filter), (Bson)newData).getModifiedCount();
    }

    public long replaceOne(Class<?> coll, Map<String, Object> filter, Map<String, Object> data) {
        return this.replaceOne(coll, filter, data);
    }

    public long replaceOne(String coll, Map<String, Object> filter, Map<String, Object> data) {
        MongoCollection<Document> collM = this.getCollection(coll);
        return collM.replaceOne((Bson)new Document(filter), (Object)new Document(data)).getModifiedCount();
    }

    public Document findOne(Class<?> coll, Map<String, Object> filter) {
        return this.findOne(coll.getSimpleName(), filter);
    }

    public Document findOne(String coll, Map<String, Object> filter) {
        FindIterable<Document> listM = this.find(coll, filter);
        listM.limit(1);
        MongoCursor mongoCursor = listM.iterator();
        if (mongoCursor.hasNext()) {
            Document item = (Document)mongoCursor.next();
            return item;
        }
        return null;
    }

    public List<Document> findMany(Class<?> coll, Map<String, Object> filter, Map<String, Object> sort) {
        return this.findMany(coll.getSimpleName(), filter, sort);
    }

    public List<Document> findMany(String coll, Map<String, Object> filter, Map<String, Object> sort) {
        FindIterable<Document> cursor = this.find(coll, filter);
        if (sort != null && sort.size() > 0) {
            cursor.sort((Bson)new Document(sort));
        }
        ArrayList<Document> list = new ArrayList<Document>();
        for (Document item : cursor) {
            list.add(item);
        }
        return list;
    }

    public List<Document> findTop(Class<?> coll, Map<String, Object> filter, Map<String, Object> sort, int top) {
        return this.findTop(coll.getSimpleName(), filter, sort, top);
    }

    public List<Document> findTop(String coll, Map<String, Object> filter, Map<String, Object> sort, int top) {
        return this.findPage(coll, filter, sort, 0, top);
    }

    public List<Document> findPage(Class<?> coll, Map<String, Object> filter, Map<String, Object> sort, int start, int size) {
        return this.findPage(coll.getSimpleName(), filter, sort, start, size);
    }

    public List<Document> findPage(String coll, Map<String, Object> filter, Map<String, Object> sort, int start, int size) {
        FindIterable<Document> cursor = this.find(coll, filter);
        if (start > 0) {
            cursor.skip(start);
        }
        if (size > 0) {
            cursor.limit(size);
        }
        if (sort != null && sort.size() > 0) {
            cursor.sort((Bson)new Document(sort));
        }
        ArrayList<Document> list = new ArrayList<Document>();
        for (Document item : cursor) {
            list.add(item);
        }
        return list;
    }

    public FindIterable<Document> find(Class<?> coll, Map<String, Object> filter) {
        return this.find(coll.getSimpleName(), filter);
    }

    public FindIterable<Document> find(String coll, Map<String, Object> filter) {
        MongoCollection<Document> collM = this.getCollection(coll);
        return collM.find((Bson)new Document(filter));
    }

    public long deleteOne(Class<?> coll, Map<String, Object> filter) {
        return this.deleteOne(coll.getSimpleName(), filter);
    }

    public long deleteOne(String coll, Map<String, Object> filter) {
        MongoCollection<Document> collM = this.getCollection(coll);
        return collM.deleteOne((Bson)new Document(filter)).getDeletedCount();
    }

    public long deleteMany(Class<?> coll, Map<String, Object> filter) {
        return this.deleteMany(coll.getSimpleName(), filter);
    }

    public long deleteMany(String coll, Map<String, Object> filter) {
        MongoCollection<Document> collM = this.getCollection(coll);
        return collM.deleteMany((Bson)new Document(filter)).getDeletedCount();
    }

    public long count(Class<?> coll) {
        return this.count(coll.getSimpleName());
    }

    public long count(String coll) {
        MongoCollection<Document> collM = this.getCollection(coll);
        return collM.estimatedDocumentCount();
    }

    public long countDocuments(Class<?> coll, Map<String, Object> filter) {
        return this.countDocuments(coll.getSimpleName(), filter);
    }

    public long countDocuments(String coll, Map<String, Object> filter) {
        MongoCollection<Document> collM = this.getCollection(coll);
        if (filter == null || filter.size() == 0) {
            return collM.countDocuments();
        }
        return collM.countDocuments((Bson)new Document(filter));
    }

    public String createIndex(String coll, Map<String, Object> keys, IndexOptions options) {
        MongoCollection<Document> collM = this.getCollection(coll);
        return collM.createIndex((Bson)new Document(keys), options);
    }

    public String createIndex(String coll, Map<String, Object> keys, Map<String, Object> options) {
        MongoCollection<Document> collM = this.getCollection(coll);
        if (options == null || options.size() == 0) {
            return collM.createIndex((Bson)new Document(keys));
        }
        DataItem dataItem = new DataItem().setMap(options);
        IndexOptions optionsM = (IndexOptions)dataItem.toEntity(IndexOptions.class);
        return collM.createIndex((Bson)new Document(keys), optionsM);
    }

    public String createIndex(String coll, Map<String, Object> keys) {
        return this.createIndex(coll, keys);
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

