/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.nacos.service;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigObserverEntity;
import org.noear.solon.cloud.service.CloudConfigService;

public class CloudConfigServiceNacosImp
implements CloudConfigService {
    ConfigService real;
    private Map<CloudConfigHandler, CloudConfigObserverEntity> observerMap = new HashMap<CloudConfigHandler, CloudConfigObserverEntity>();

    public CloudConfigServiceNacosImp(CloudProps cloudProps) {
        String server = cloudProps.getConfigServer();
        String username = cloudProps.getUsername();
        String password = cloudProps.getPassword();
        Properties properties = new Properties();
        properties.put("serverAddr", server);
        if (Utils.isNotEmpty((String)username)) {
            properties.put("username", username);
        }
        if (Utils.isNotEmpty((String)password)) {
            properties.put("password", password);
        }
        try {
            this.real = ConfigFactory.createConfigService((Properties)properties);
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Config pull(String group, String key) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        try {
            group = this.groupReview(group);
            String value = this.real.getConfig(key, group, 3000L);
            return new Config(group, key, value, 0L);
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean push(String group, String key, String value) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        try {
            group = this.groupReview(group);
            return this.real.publishConfig(key, group, value);
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean remove(String group, String key) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        try {
            group = this.groupReview(group);
            return this.real.removeConfig(key, group);
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void attention(String group, String key, CloudConfigHandler observer) {
        if (this.observerMap.containsKey(observer)) {
            return;
        }
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        final CloudConfigObserverEntity entity = new CloudConfigObserverEntity(group, key, observer);
        this.observerMap.put(observer, entity);
        try {
            group = this.groupReview(group);
            this.real.addListener(key, group, new Listener(){

                public Executor getExecutor() {
                    return null;
                }

                public void receiveConfigInfo(String value) {
                    entity.handler(new Config(entity.group, entity.key, value, 0L));
                }
            });
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String groupReview(String group) {
        if (Utils.isEmpty((String)group)) {
            return null;
        }
        return group;
    }
}

