/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.nacos.impl;

import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.core.Props;

public class NacosConfig {
    public static Properties getServiceProperties(CloudProps cloudProps, Properties properties, String server) {
        String username = cloudProps.getUsername();
        String password = cloudProps.getPassword();
        Props parentProps = cloudProps.getProp();
        parentProps.forEach((k, v) -> {
            if (k instanceof String) {
                String key = (String)k;
                if (key.startsWith("config.") || key.startsWith("discovery.")) {
                    return;
                }
                properties.putIfAbsent(key, v);
            }
        });
        properties.putIfAbsent("serverAddr", server);
        if (Utils.isNotEmpty((String)username)) {
            properties.putIfAbsent("username", username);
        }
        if (Utils.isNotEmpty((String)password)) {
            properties.putIfAbsent("password", password);
        }
        if (Utils.isNotEmpty((String)cloudProps.getNamespace())) {
            properties.putIfAbsent("namespace", cloudProps.getNamespace());
        }
        return properties;
    }
}

