/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.http.hutool;

import cn.hutool.http.HttpResponse;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Map;
import org.noear.nami.Encoder;
import org.noear.nami.NamiChannel;
import org.noear.nami.NamiConfig;
import org.noear.nami.NamiManager;
import org.noear.nami.channel.http.hutool.HttpUtils;
import org.noear.nami.common.Result;

public class HttpChannel
implements NamiChannel {
    public static final HttpChannel instance = new HttpChannel();

    public Result call(NamiConfig cfg, Method method, String action, String url, Map<String, String> headers, Map<String, Object> args, Object body) throws Throwable {
        byte[] bytes;
        boolean is_get = "GET".equals(action);
        if (is_get && args.size() > 0) {
            StringBuilder sb = new StringBuilder(url).append("?");
            args.forEach((k, v) -> {
                if (v != null) {
                    sb.append((String)k).append("=").append(HttpUtils.urlEncode(v.toString())).append("&");
                }
            });
            url = sb.substring(0, sb.length() - 1);
        }
        if (cfg.getDecoder() == null) {
            throw new IllegalArgumentException("There is no suitable decoder");
        }
        cfg.getDecoder().filter(cfg, action, url, headers, args);
        HttpUtils http = HttpUtils.http(url).headers(headers);
        HttpResponse response = null;
        Encoder encoder = cfg.getEncoder();
        if (is_get || args.size() == 0) {
            response = http.exec("GET");
        } else if (encoder == null) {
            String ct0 = headers.getOrDefault("Content-Type", "");
            if (ct0.length() == 0) {
                response = http.data(args).exec(action);
            } else {
                encoder = NamiManager.getEncoder((String)ct0);
            }
        } else {
            encoder = cfg.getEncoder();
        }
        if (response == null && encoder != null && (bytes = encoder.encode(body)) != null) {
            response = http.bodyRaw(bytes, encoder.enctype()).exec(action);
        }
        if (response == null) {
            return null;
        }
        Result result = new Result(response.getStatus(), response.body().getBytes());
        response.headers().forEach((k, ary) -> {
            if (ary.size() > 0) {
                result.headerAdd(k, (String)ary.get(0));
            }
        });
        String charset = response.charset();
        if (charset != null) {
            result.charsetSet(Charset.forName(charset));
        }
        return result;
    }

    public void filter(NamiConfig cfg, String method, String url, Map<String, String> headers, Map<String, Object> args) {
        String ct;
        if (cfg.getDecoder() == null) {
            String at = cfg.getHeader("Accept");
            if (at == null) {
                at = "application/json";
            }
            cfg.setDecoder(NamiManager.getDecoder((String)at));
        }
        if (cfg.getEncoder() == null && (ct = cfg.getHeader("Content-Type")) != null) {
            cfg.setEncoder(NamiManager.getEncoder((String)ct));
        }
    }
}

