/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.socketd;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.noear.nami.Channel;
import org.noear.nami.ChannelBase;
import org.noear.nami.Context;
import org.noear.nami.Result;
import org.noear.nami.channel.socketd.SocketdChannel;
import org.noear.nami.channel.socketd.SocketdProxy;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Session;

public class SocketdClientChannel
extends ChannelBase
implements Channel {
    public static final SocketdClientChannel instance = new SocketdClientChannel();
    private final Map<String, SocketdChannel> channelMap = new HashMap<String, SocketdChannel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketdChannel get(String hostname, String url) {
        SocketdChannel channel = this.channelMap.get(hostname);
        if (channel == null) {
            Map<String, SocketdChannel> map = this.channelMap;
            synchronized (map) {
                channel = this.channelMap.get(hostname);
                if (channel == null) {
                    try {
                        Session session = (Session)SocketD.createClient((String)url).listen((Listener)SocketdProxy.socketdToHandler).open();
                        channel = new SocketdChannel(() -> session);
                        this.channelMap.put(hostname, channel);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
        return channel;
    }

    public Result call(Context ctx) throws Throwable {
        this.pretreatment(ctx);
        URI uri = URI.create(ctx.url);
        String hostname = uri.getAuthority();
        SocketdChannel channel = this.get(hostname, ctx.url);
        return channel.call(ctx);
    }
}

