/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.powerjob.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import org.noear.solon.cloud.extend.powerjob.JobBeanManager;
import org.noear.solon.cloud.extend.powerjob.JobManager;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enums.ProcessorType;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;
import tech.powerjob.worker.extension.processor.ProcessorBean;
import tech.powerjob.worker.extension.processor.ProcessorDefinition;
import tech.powerjob.worker.extension.processor.ProcessorFactory;

public class ProcessorFactoryOfSolon
implements ProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(ProcessorFactoryOfSolon.class);
    private final AopContext context;

    public ProcessorFactoryOfSolon(AopContext context) {
        this.context = context;
    }

    public Set<String> supportTypes() {
        return Sets.newHashSet((Object[])new String[]{ProcessorType.BUILT_IN.name()});
    }

    public ProcessorBean build(ProcessorDefinition processorDefinition) {
        try {
            BasicProcessor bean = this.getBean(processorDefinition.getProcessorInfo());
            return new ProcessorBean().setProcessor(bean).setClassLoader(bean.getClass().getClassLoader());
        }
        catch (Exception e) {
            log.warn("[ProcessorFactory] load by ProcessorFactoryOfSolon failed. If you are using Solon, make sure this bean was managed by Solon", (Throwable)e);
            return null;
        }
    }

    private BasicProcessor getBean(String name) throws Exception {
        BasicProcessor processorProxy = JobManager.getJob(name);
        if (processorProxy != null) {
            return processorProxy;
        }
        BeanWrap beanWrap = JobBeanManager.getJob(name);
        if (beanWrap == null) {
            throw new IllegalStateException("[ProcessorFactory] Missing processor info\uff1a " + name);
        }
        return (BasicProcessor)beanWrap.get();
    }
}

