/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.powerjob;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.powerjob.impl.PowerJobBeanBuilder;
import org.noear.solon.cloud.extend.powerjob.impl.PowerJobProperties;
import org.noear.solon.cloud.extend.powerjob.impl.PowerJobWorkerOfSolon;
import org.noear.solon.cloud.extend.powerjob.service.CloudJobServiceImpl;
import org.noear.solon.cloud.impl.CloudJobBeanBuilder;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.client.PowerJobClient;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;

public class XPluginImp
implements Plugin {
    private static final Logger logger = LoggerFactory.getLogger(XPluginImp.class);

    public void start(AppContext context) throws Throwable {
        CloudProps cloudProps = new CloudProps(context, "powerjob");
        if (!cloudProps.getJobEnable()) {
            logger.warn("PowerJob is disabled, powerjob worker will not start.");
            return;
        }
        if (Utils.isBlank((String)cloudProps.getJobServer())) {
            logger.error("PowerJob server can't be empty! ");
            return;
        }
        if (Utils.isBlank((String)Solon.cfg().appName())) {
            logger.error("solon.app.name is empty, powerjob worker will not start.");
            return;
        }
        if (Utils.isNotBlank((String)cloudProps.getPassword())) {
            PowerJobClient client = new PowerJobClient(cloudProps.getJobServer(), Solon.cfg().appName(), cloudProps.getPassword());
            context.beanInject((Object)client);
            context.wrapAndPut(PowerJobClient.class, (Object)client);
        }
        PowerJobProperties properties = (PowerJobProperties)cloudProps.getProp("job").getBean(PowerJobProperties.class);
        PowerJobWorkerConfig config = properties.toConfig(cloudProps);
        PowerJobWorkerOfSolon worker = new PowerJobWorkerOfSolon(context, config);
        context.beanInject((Object)worker);
        context.wrapAndPut(PowerJobWorkerOfSolon.class, (Object)worker);
        CloudManager.register((CloudJobService)new CloudJobServiceImpl());
        CloudJobBeanBuilder.getInstance().addBuilder(BasicProcessor.class, (BeanBuilder)new PowerJobBeanBuilder());
    }
}

