/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.powerjob.impl;

import java.util.Arrays;
import lombok.Generated;
import org.noear.solon.Solon;
import org.noear.solon.cloud.CloudProps;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.common.constants.StoreStrategy;

public class PowerJobProperties {
    private Integer port = 27777;
    private Protocol protocol = Protocol.AKKA;
    private StoreStrategy storeStrategy = StoreStrategy.DISK;
    private int maxResultLength = 8192;
    @Deprecated
    private boolean enableTestMode = false;
    private boolean allowLazyConnectServer = false;
    private int maxAppendedWfContextLength = 8192;
    private String tag;
    private Integer maxLightweightTaskNum = 1024;
    private Integer maxHeavyweightTaskNum = 64;
    private Integer healthReportInterval = 10;

    public PowerJobWorkerConfig toConfig(CloudProps cloudProps) {
        PowerJobWorkerConfig config = new PowerJobWorkerConfig();
        if (this.getPort() != null) {
            config.setPort(this.getPort().intValue());
        } else {
            config.setPort(NetUtils.getRandomPort());
        }
        config.setAppName(Solon.cfg().appName());
        config.setServerAddress(Arrays.asList(cloudProps.getJobServer().split(",")));
        config.setProtocol(this.getProtocol());
        config.setStoreStrategy(this.getStoreStrategy());
        if (this.isEnableTestMode()) {
            config.setAllowLazyConnectServer(true);
        } else {
            config.setAllowLazyConnectServer(this.isAllowLazyConnectServer());
        }
        config.setMaxAppendedWfContextLength(this.getMaxAppendedWfContextLength());
        config.setTag(this.getTag());
        config.setMaxHeavyweightTaskNum(this.getMaxHeavyweightTaskNum());
        config.setMaxLightweightTaskNum(this.getMaxLightweightTaskNum());
        config.setHealthReportInterval(this.getHealthReportInterval());
        return config;
    }

    @Generated
    public PowerJobProperties() {
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Generated
    public StoreStrategy getStoreStrategy() {
        return this.storeStrategy;
    }

    @Generated
    public int getMaxResultLength() {
        return this.maxResultLength;
    }

    @Deprecated
    @Generated
    public boolean isEnableTestMode() {
        return this.enableTestMode;
    }

    @Generated
    public boolean isAllowLazyConnectServer() {
        return this.allowLazyConnectServer;
    }

    @Generated
    public int getMaxAppendedWfContextLength() {
        return this.maxAppendedWfContextLength;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public Integer getMaxLightweightTaskNum() {
        return this.maxLightweightTaskNum;
    }

    @Generated
    public Integer getMaxHeavyweightTaskNum() {
        return this.maxHeavyweightTaskNum;
    }

    @Generated
    public Integer getHealthReportInterval() {
        return this.healthReportInterval;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setStoreStrategy(StoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
    }

    @Generated
    public void setMaxResultLength(int maxResultLength) {
        this.maxResultLength = maxResultLength;
    }

    @Deprecated
    @Generated
    public void setEnableTestMode(boolean enableTestMode) {
        this.enableTestMode = enableTestMode;
    }

    @Generated
    public void setAllowLazyConnectServer(boolean allowLazyConnectServer) {
        this.allowLazyConnectServer = allowLazyConnectServer;
    }

    @Generated
    public void setMaxAppendedWfContextLength(int maxAppendedWfContextLength) {
        this.maxAppendedWfContextLength = maxAppendedWfContextLength;
    }

    @Generated
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Generated
    public void setMaxLightweightTaskNum(Integer maxLightweightTaskNum) {
        this.maxLightweightTaskNum = maxLightweightTaskNum;
    }

    @Generated
    public void setMaxHeavyweightTaskNum(Integer maxHeavyweightTaskNum) {
        this.maxHeavyweightTaskNum = maxHeavyweightTaskNum;
    }

    @Generated
    public void setHealthReportInterval(Integer healthReportInterval) {
        this.healthReportInterval = healthReportInterval;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerJobProperties)) {
            return false;
        }
        PowerJobProperties other = (PowerJobProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxResultLength() != other.getMaxResultLength()) {
            return false;
        }
        if (this.isEnableTestMode() != other.isEnableTestMode()) {
            return false;
        }
        if (this.isAllowLazyConnectServer() != other.isAllowLazyConnectServer()) {
            return false;
        }
        if (this.getMaxAppendedWfContextLength() != other.getMaxAppendedWfContextLength()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$maxLightweightTaskNum = this.getMaxLightweightTaskNum();
        Integer other$maxLightweightTaskNum = other.getMaxLightweightTaskNum();
        if (this$maxLightweightTaskNum == null ? other$maxLightweightTaskNum != null : !((Object)this$maxLightweightTaskNum).equals(other$maxLightweightTaskNum)) {
            return false;
        }
        Integer this$maxHeavyweightTaskNum = this.getMaxHeavyweightTaskNum();
        Integer other$maxHeavyweightTaskNum = other.getMaxHeavyweightTaskNum();
        if (this$maxHeavyweightTaskNum == null ? other$maxHeavyweightTaskNum != null : !((Object)this$maxHeavyweightTaskNum).equals(other$maxHeavyweightTaskNum)) {
            return false;
        }
        Integer this$healthReportInterval = this.getHealthReportInterval();
        Integer other$healthReportInterval = other.getHealthReportInterval();
        if (this$healthReportInterval == null ? other$healthReportInterval != null : !((Object)this$healthReportInterval).equals(other$healthReportInterval)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        StoreStrategy this$storeStrategy = this.getStoreStrategy();
        StoreStrategy other$storeStrategy = other.getStoreStrategy();
        if (this$storeStrategy == null ? other$storeStrategy != null : !this$storeStrategy.equals(other$storeStrategy)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerJobProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxResultLength();
        result = result * 59 + (this.isEnableTestMode() ? 79 : 97);
        result = result * 59 + (this.isAllowLazyConnectServer() ? 79 : 97);
        result = result * 59 + this.getMaxAppendedWfContextLength();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $maxLightweightTaskNum = this.getMaxLightweightTaskNum();
        result = result * 59 + ($maxLightweightTaskNum == null ? 43 : ((Object)$maxLightweightTaskNum).hashCode());
        Integer $maxHeavyweightTaskNum = this.getMaxHeavyweightTaskNum();
        result = result * 59 + ($maxHeavyweightTaskNum == null ? 43 : ((Object)$maxHeavyweightTaskNum).hashCode());
        Integer $healthReportInterval = this.getHealthReportInterval();
        result = result * 59 + ($healthReportInterval == null ? 43 : ((Object)$healthReportInterval).hashCode());
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        StoreStrategy $storeStrategy = this.getStoreStrategy();
        result = result * 59 + ($storeStrategy == null ? 43 : $storeStrategy.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PowerJobProperties(port=" + this.getPort() + ", protocol=" + this.getProtocol() + ", storeStrategy=" + this.getStoreStrategy() + ", maxResultLength=" + this.getMaxResultLength() + ", enableTestMode=" + this.isEnableTestMode() + ", allowLazyConnectServer=" + this.isAllowLazyConnectServer() + ", maxAppendedWfContextLength=" + this.getMaxAppendedWfContextLength() + ", tag=" + this.getTag() + ", maxLightweightTaskNum=" + this.getMaxLightweightTaskNum() + ", maxHeavyweightTaskNum=" + this.getMaxHeavyweightTaskNum() + ", healthReportInterval=" + this.getHealthReportInterval() + ")";
    }
}

