/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.powerjob.impl;

import java.util.Arrays;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.common.constants.StoreStrategy;

public class PowerJobProperties {
    private boolean enabled = true;
    private String appName;
    private String password;
    private Integer port = 27777;
    private String serverAddress;
    private Protocol protocol = Protocol.AKKA;
    private StoreStrategy storeStrategy = StoreStrategy.DISK;
    private int maxResultLength = 8192;
    private boolean enableTestMode = false;
    private int maxAppendedWfContextLength = 8192;
    private String tag;
    private Integer maxLightweightTaskNum = 1024;
    private Integer maxHeavyweightTaskNum = 64;
    private Integer healthReportInterval = 10;

    public PowerJobWorkerConfig toConfig() {
        PowerJobWorkerConfig config = new PowerJobWorkerConfig();
        if (this.getPort() != null) {
            config.setPort(this.getPort().intValue());
        } else {
            config.setPort(NetUtils.getRandomPort());
        }
        config.setAppName(this.getAppName());
        config.setServerAddress(Arrays.asList(this.getServerAddress().split(",")));
        config.setProtocol(this.getProtocol());
        config.setStoreStrategy(this.getStoreStrategy());
        config.setEnableTestMode(this.isEnableTestMode());
        config.setMaxAppendedWfContextLength(this.getMaxAppendedWfContextLength());
        config.setTag(this.getTag());
        config.setMaxHeavyweightTaskNum(this.getMaxHeavyweightTaskNum());
        config.setMaxLightweightTaskNum(this.getMaxLightweightTaskNum());
        config.setHealthReportInterval(this.getHealthReportInterval());
        return config;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public StoreStrategy getStoreStrategy() {
        return this.storeStrategy;
    }

    public int getMaxResultLength() {
        return this.maxResultLength;
    }

    public boolean isEnableTestMode() {
        return this.enableTestMode;
    }

    public int getMaxAppendedWfContextLength() {
        return this.maxAppendedWfContextLength;
    }

    public String getTag() {
        return this.tag;
    }

    public Integer getMaxLightweightTaskNum() {
        return this.maxLightweightTaskNum;
    }

    public Integer getMaxHeavyweightTaskNum() {
        return this.maxHeavyweightTaskNum;
    }

    public Integer getHealthReportInterval() {
        return this.healthReportInterval;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setStoreStrategy(StoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
    }

    public void setMaxResultLength(int maxResultLength) {
        this.maxResultLength = maxResultLength;
    }

    public void setEnableTestMode(boolean enableTestMode) {
        this.enableTestMode = enableTestMode;
    }

    public void setMaxAppendedWfContextLength(int maxAppendedWfContextLength) {
        this.maxAppendedWfContextLength = maxAppendedWfContextLength;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setMaxLightweightTaskNum(Integer maxLightweightTaskNum) {
        this.maxLightweightTaskNum = maxLightweightTaskNum;
    }

    public void setMaxHeavyweightTaskNum(Integer maxHeavyweightTaskNum) {
        this.maxHeavyweightTaskNum = maxHeavyweightTaskNum;
    }

    public void setHealthReportInterval(Integer healthReportInterval) {
        this.healthReportInterval = healthReportInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerJobProperties)) {
            return false;
        }
        PowerJobProperties other = (PowerJobProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getMaxResultLength() != other.getMaxResultLength()) {
            return false;
        }
        if (this.isEnableTestMode() != other.isEnableTestMode()) {
            return false;
        }
        if (this.getMaxAppendedWfContextLength() != other.getMaxAppendedWfContextLength()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$maxLightweightTaskNum = this.getMaxLightweightTaskNum();
        Integer other$maxLightweightTaskNum = other.getMaxLightweightTaskNum();
        if (this$maxLightweightTaskNum == null ? other$maxLightweightTaskNum != null : !((Object)this$maxLightweightTaskNum).equals(other$maxLightweightTaskNum)) {
            return false;
        }
        Integer this$maxHeavyweightTaskNum = this.getMaxHeavyweightTaskNum();
        Integer other$maxHeavyweightTaskNum = other.getMaxHeavyweightTaskNum();
        if (this$maxHeavyweightTaskNum == null ? other$maxHeavyweightTaskNum != null : !((Object)this$maxHeavyweightTaskNum).equals(other$maxHeavyweightTaskNum)) {
            return false;
        }
        Integer this$healthReportInterval = this.getHealthReportInterval();
        Integer other$healthReportInterval = other.getHealthReportInterval();
        if (this$healthReportInterval == null ? other$healthReportInterval != null : !((Object)this$healthReportInterval).equals(other$healthReportInterval)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$serverAddress = this.getServerAddress();
        String other$serverAddress = other.getServerAddress();
        if (this$serverAddress == null ? other$serverAddress != null : !this$serverAddress.equals(other$serverAddress)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        StoreStrategy this$storeStrategy = this.getStoreStrategy();
        StoreStrategy other$storeStrategy = other.getStoreStrategy();
        if (this$storeStrategy == null ? other$storeStrategy != null : !this$storeStrategy.equals(other$storeStrategy)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PowerJobProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getMaxResultLength();
        result = result * 59 + (this.isEnableTestMode() ? 79 : 97);
        result = result * 59 + this.getMaxAppendedWfContextLength();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $maxLightweightTaskNum = this.getMaxLightweightTaskNum();
        result = result * 59 + ($maxLightweightTaskNum == null ? 43 : ((Object)$maxLightweightTaskNum).hashCode());
        Integer $maxHeavyweightTaskNum = this.getMaxHeavyweightTaskNum();
        result = result * 59 + ($maxHeavyweightTaskNum == null ? 43 : ((Object)$maxHeavyweightTaskNum).hashCode());
        Integer $healthReportInterval = this.getHealthReportInterval();
        result = result * 59 + ($healthReportInterval == null ? 43 : ((Object)$healthReportInterval).hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $serverAddress = this.getServerAddress();
        result = result * 59 + ($serverAddress == null ? 43 : $serverAddress.hashCode());
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        StoreStrategy $storeStrategy = this.getStoreStrategy();
        result = result * 59 + ($storeStrategy == null ? 43 : $storeStrategy.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    public String toString() {
        return "PowerJobProperties(enabled=" + this.isEnabled() + ", appName=" + this.getAppName() + ", password=" + this.getPassword() + ", port=" + this.getPort() + ", serverAddress=" + this.getServerAddress() + ", protocol=" + this.getProtocol() + ", storeStrategy=" + this.getStoreStrategy() + ", maxResultLength=" + this.getMaxResultLength() + ", enableTestMode=" + this.isEnableTestMode() + ", maxAppendedWfContextLength=" + this.getMaxAppendedWfContextLength() + ", tag=" + this.getTag() + ", maxLightweightTaskNum=" + this.getMaxLightweightTaskNum() + ", maxHeavyweightTaskNum=" + this.getMaxHeavyweightTaskNum() + ", healthReportInterval=" + this.getHealthReportInterval() + ")";
    }
}

