/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.powerjob;

import org.apache.commons.lang3.StringUtils;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.Plugin;
import org.noear.solon.extend.powerjob.impl.PowerJobBeanBuilder;
import org.noear.solon.extend.powerjob.impl.PowerJobProperties;
import org.noear.solon.extend.powerjob.impl.PowerJobWorkerOfSolon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.client.PowerJobClient;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.solon.annotation.PowerJob;
import tech.powerjob.worker.common.PowerJobWorkerConfig;

public class XPluginImp
implements Plugin {
    private static final Logger logger = LoggerFactory.getLogger(XPluginImp.class);

    public void start(AppContext context) throws Throwable {
        PowerJobProperties properties = (PowerJobProperties)context.cfg().getBean("solon.powerjob", PowerJobProperties.class);
        if (properties == null || !properties.isEnabled()) {
            logger.warn("PowerJob is disabled, powerjob worker will not start.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)properties.getAppName())) {
            properties.setAppName(Solon.cfg().appName());
        }
        if (StringUtils.isBlank((CharSequence)properties.getAppName())) {
            logger.error("PowerJob app Name is empty, powerjob worker will not start.");
            return;
        }
        context.beanBuilderAdd(PowerJob.class, (BeanBuilder)new PowerJobBeanBuilder());
        CommonUtils.requireNonNull((Object)properties.getServerAddress(), (String)"serverAddress can't be empty! if you don't want to enable powerjob, please config program arguments: solon.powerjob.worker.enabled=false");
        PowerJobWorkerConfig config = properties.toConfig();
        if (StringUtils.isNotBlank((CharSequence)properties.getPassword())) {
            PowerJobClient client = new PowerJobClient(config.getServerAddress(), config.getAppName(), properties.getPassword());
            context.beanInject((Object)client);
            context.wrapAndPut(PowerJobClient.class, (Object)client);
        }
        PowerJobWorkerOfSolon worker = new PowerJobWorkerOfSolon(context, config);
        context.beanInject((Object)worker);
        context.wrapAndPut(PowerJobWorkerOfSolon.class, (Object)worker);
    }
}

