/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.powerjob.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.noear.solon.core.AppContext;
import org.noear.solon.extend.powerjob.impl.ProcessorFactoryOfSolon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.worker.PowerJobWorker;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.extension.processor.ProcessorFactory;

public class PowerJobWorkerOfSolon
extends PowerJobWorker {
    private static final Logger logger = LoggerFactory.getLogger(PowerJobWorkerOfSolon.class);
    final ProcessorFactoryOfSolon processorFactory;

    public PowerJobWorkerOfSolon(AppContext context, PowerJobWorkerConfig config) {
        super(config);
        this.processorFactory = new ProcessorFactoryOfSolon(context);
        try {
            this.init();
        }
        catch (Exception e) {
            logger.error("Powerjob worker start failed.", (Throwable)e);
        }
    }

    public void init() throws Exception {
        this.addProcessorFactory(this.processorFactory);
        super.init();
    }

    public void addProcessorFactory(ProcessorFactory processorFactory) {
        PowerJobWorkerConfig workerConfig = this.workerRuntime.getWorkerConfig();
        ArrayList processorFactories = Lists.newArrayList((Iterable)Optional.ofNullable(workerConfig.getProcessorFactoryList()).orElse(Collections.emptyList()));
        processorFactories.add(processorFactory);
        workerConfig.setProcessorFactoryList((List)processorFactories);
    }
}

