/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.pulsar.impl;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.utils.ExpirationUtils;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarMessageListenerImpl
implements MessageListener<byte[]> {
    static Logger log = LoggerFactory.getLogger(PulsarMessageListenerImpl.class);
    CloudEventObserverManger observerManger;
    String eventChannelName;

    public PulsarMessageListenerImpl(CloudProps cloudProps, CloudEventObserverManger observerManger) {
        this.observerManger = observerManger;
        this.eventChannelName = cloudProps.getEventChannel();
    }

    public void received(Consumer<byte[]> consumer, Message<byte[]> msg) {
        try {
            String event_json = new String((byte[])msg.getValue());
            Event event = (Event)ONode.deserialize((String)event_json, Event.class);
            event.channel(this.eventChannelName);
            boolean isOk = this.onReceive(event);
            if (!isOk) {
                event.times(event.times() + 1);
                consumer.reconsumeLater(msg, ExpirationUtils.getExpiration((int)event.times()), TimeUnit.SECONDS);
            } else {
                consumer.acknowledge(msg);
            }
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap((Throwable)ex);
            EventBus.push((Object)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void reachedEndOfTopic(Consumer<byte[]> consumer) {
        super.reachedEndOfTopic(consumer);
    }

    public boolean onReceive(Event event) throws Throwable {
        boolean isOk = true;
        CloudEventHandler handler = null;
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + ":" + event.topic();
        handler = this.observerManger.get(topicNew);
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)topicNew);
        }
        return isOk;
    }
}

