/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.pulsar.service;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.pulsar.impl.PulsarMessageListenerImpl;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;

public class CloudEventServicePulsarImp
implements CloudEventServicePlus {
    private final CloudProps cloudProps;
    private PulsarClient client;
    CloudEventObserverManger observerManger = new CloudEventObserverManger();
    private String channel;
    private String group;

    public CloudEventServicePulsarImp(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        try {
            this.client = PulsarClient.builder().serviceUrl(cloudProps.getEventServer()).build();
        }
        catch (PulsarClientException e) {
            throw new CloudEventException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean publish(Event event) throws CloudEventException {
        if (Utils.isEmpty((String)event.topic())) {
            throw new IllegalArgumentException("Event missing topic");
        }
        if (Utils.isEmpty((String)event.content())) {
            throw new IllegalArgumentException("Event missing content");
        }
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        String topicNew = Utils.isEmpty((String)event.group()) ? event.topic() : event.group() + ":" + event.topic();
        byte[] event_data = ONode.stringify((Object)event).getBytes(StandardCharsets.UTF_8);
        try (Producer producer = this.client.newProducer().topic(topicNew).create();){
            if (event.scheduled() == null) {
                producer.newMessage().key(event.key()).value((Object)event_data).send();
            } else {
                producer.newMessage().key(event.key()).value((Object)event_data).deliverAt(event.scheduled().getTime()).send();
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            throw new CloudEventException(ex);
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, CloudEventHandler observer) {
        String topicNew = Utils.isEmpty((String)group) ? topic : group + ":" + topic;
        this.observerManger.add(topicNew, level, group, topic, observer);
    }

    public void subscribe() {
        if (this.observerManger.topicSize() > 0) {
            String consumerGroup = this.getEventConsumerGroup();
            if (Utils.isEmpty((String)consumerGroup)) {
                consumerGroup = Solon.cfg().appGroup() + "_" + Solon.cfg().appName();
            }
            try {
                this.client.newConsumer().topics(new ArrayList(this.observerManger.topicAll())).messageListener((MessageListener)new PulsarMessageListenerImpl(this.cloudProps, this.observerManger)).subscriptionName(consumerGroup).subscriptionType(SubscriptionType.Shared).subscribe();
            }
            catch (Exception e) {
                throw new CloudEventException((Throwable)e);
            }
        }
    }

    public String getChannel() {
        if (this.channel == null) {
            this.channel = this.cloudProps.getEventChannel();
        }
        return this.channel;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = this.cloudProps.getEventGroup();
        }
        return this.group;
    }

    public String getEventConsumerGroup() {
        return this.cloudProps.getProp("event.consumerGroup");
    }

    public String getEventProducerGroup() {
        return this.cloudProps.getProp("event.producerGroup");
    }
}

