/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.qiniu.kodo.service;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.cloud.utils.http.HttpUtils;
import org.noear.solon.core.handle.Result;

public class CloudFileServiceKodoImp
implements CloudFileService {
    protected final String bucketDef;
    protected final String regionId;
    protected final String accessKey;
    protected final String secretKey;
    protected final String endpoint;
    protected final Auth auth;
    protected final UploadManager uploadManager;
    protected final BucketManager bucketManager;

    public CloudFileServiceKodoImp(CloudProps cloudProps) {
        this(cloudProps, null);
    }

    public CloudFileServiceKodoImp(CloudProps cloudProps, Region region) {
        this.bucketDef = cloudProps.getFileBucket();
        this.regionId = cloudProps.getFileRegionId();
        this.accessKey = cloudProps.getFileAccessKey();
        this.secretKey = cloudProps.getFileSecretKey();
        this.endpoint = cloudProps.getFileEndpoint();
        this.auth = Auth.create((String)this.accessKey, (String)this.secretKey);
        Configuration cfg = this.buildConfig(region);
        this.uploadManager = new UploadManager(cfg);
        this.bucketManager = new BucketManager(this.auth, cfg);
    }

    public Configuration buildConfig(Region region) {
        if (region != null) {
            return new Configuration(region);
        }
        switch (this.regionId) {
            case "z0": {
                return new Configuration(Region.region0());
            }
            case "huadong": {
                return new Configuration(Region.huadong());
            }
            case "cn-east-2": {
                return new Configuration(Region.regionCnEast2());
            }
            case "zhejiang2": {
                return new Configuration(Region.huadongZheJiang2());
            }
            case "z1": {
                return new Configuration(Region.region1());
            }
            case "huabei": {
                return new Configuration(Region.huabei());
            }
            case "z2": {
                return new Configuration(Region.region2());
            }
            case "huanan": {
                return new Configuration(Region.huanan());
            }
            case "na0": {
                return new Configuration(Region.regionNa0());
            }
            case "beimei": {
                return new Configuration(Region.beimei());
            }
            case "as0": 
            case "xinjiapo": {
                return new Configuration(Region.xinjiapo());
            }
            case "fog-cn-east-1": {
                return new Configuration(Region.regionFogCnEast1());
            }
        }
        return new Configuration();
    }

    public Media get(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        String baseUrl = this.buildUrl(key);
        String downUrl = this.auth.privateDownloadUrl(baseUrl);
        try {
            ResponseBody obj = HttpUtils.http((String)downUrl).exec("GET").body();
            return new Media(obj.byteStream(), obj.contentType().toString());
        }
        catch (IOException e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    public Result put(String bucket, String key, Media media) throws CloudFileException {
        String streamMime;
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        if (Utils.isEmpty((String)(streamMime = media.contentType()))) {
            streamMime = "text/plain; charset=utf-8";
        }
        String uploadToken = this.auth.uploadToken(bucket);
        try {
            Response resp = this.uploadManager.put(media.body(), key, uploadToken, new StringMap(), streamMime);
            return Result.succeed((Object)resp.bodyString());
        }
        catch (QiniuException e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    public Result delete(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            Response resp = this.bucketManager.delete(bucket, key);
            return Result.succeed((Object)resp.bodyString());
        }
        catch (QiniuException e) {
            return Result.failure((String)e.error());
        }
    }

    private String buildUrl(String key) {
        if (this.endpoint.contains("://")) {
            return this.endpoint + "/" + key;
        }
        return "https://" + this.endpoint + "/" + key;
    }
}

