/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.qiniu.kodo.service;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.noear.solon.Utils;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.extend.qiniu.kodo.KodoProps;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.cloud.utils.http.HttpUtils;
import org.noear.solon.core.handle.Result;

public class CloudFileServiceKodoImp
implements CloudFileService {
    private static CloudFileServiceKodoImp instance;
    protected final String bucketDef = KodoProps.instance.getFileBucket();
    protected final String accessKey = KodoProps.instance.getFileAccessKey();
    protected final String secretKey = KodoProps.instance.getFileSecretKey();
    protected final String endpoint = KodoProps.instance.getFileEndpoint();
    protected final Auth auth = Auth.create((String)this.accessKey, (String)this.secretKey);
    protected final UploadManager uploadManager;
    protected final BucketManager bucketManager;

    public static synchronized CloudFileServiceKodoImp getInstance() {
        if (instance == null) {
            instance = new CloudFileServiceKodoImp();
        }
        return instance;
    }

    public CloudFileServiceKodoImp() {
        Configuration cfg = new Configuration(Region.region0());
        this.uploadManager = new UploadManager(cfg);
        this.bucketManager = new BucketManager(this.auth, cfg);
    }

    public Media get(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        String baseUrl = this.buildUrl(key);
        String downUrl = this.auth.privateDownloadUrl(baseUrl);
        try {
            ResponseBody obj = HttpUtils.http((String)downUrl).exec("GET").body();
            return new Media(obj.byteStream(), obj.contentType().toString());
        }
        catch (IOException e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    public Result put(String bucket, String key, Media media) throws CloudFileException {
        String streamMime;
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        if (Utils.isEmpty((String)(streamMime = media.contentType()))) {
            streamMime = "text/plain; charset=utf-8";
        }
        String uploadToken = this.auth.uploadToken(bucket);
        try {
            Response resp = this.uploadManager.put(media.body(), key, uploadToken, new StringMap(), streamMime);
            return Result.succeed((Object)resp.bodyString());
        }
        catch (QiniuException e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    public Result delete(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        try {
            Response resp = this.bucketManager.delete(bucket, key);
            return Result.succeed((Object)resp.bodyString());
        }
        catch (QiniuException e) {
            return Result.failure((String)e.error());
        }
    }

    private String buildUrl(String key) {
        if (this.endpoint.contains("://")) {
            return this.endpoint + "/" + key;
        }
        return "https://" + this.endpoint + "/" + key;
    }
}

