/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.qiniu.kodo.service;

import com.qiniu.common.QiniuException;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;
import org.noear.solon.Utils;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.extend.qiniu.kodo.KodoProps;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.cloud.tool.HttpUtils;
import org.noear.solon.core.handle.Result;

public class CloudFileServiceKodoImp
implements CloudFileService {
    private static CloudFileServiceKodoImp instance;
    protected final String bucketDef = KodoProps.instance.getFileBucket();
    protected final String accessKey = KodoProps.instance.getFileAccessKey();
    protected final String secretKey = KodoProps.instance.getFileSecretKey();
    protected final String endpoint = KodoProps.instance.getFileEndpoint();
    protected final Auth auth = Auth.create((String)this.accessKey, (String)this.secretKey);
    protected final UploadManager uploadManager;

    public static synchronized CloudFileServiceKodoImp getInstance() {
        if (instance == null) {
            instance = new CloudFileServiceKodoImp();
        }
        return instance;
    }

    public CloudFileServiceKodoImp() {
        Configuration cfg = new Configuration(Region.region0());
        this.uploadManager = new UploadManager(cfg);
    }

    public InputStream getStream(String bucket, String key) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        String baseUrl = this.buildUrl(key);
        String downUrl = this.auth.privateDownloadUrl(baseUrl);
        try {
            Response response = HttpUtils.http((String)downUrl).exec("GET");
            return response.body().byteStream();
        }
        catch (IOException e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    public Result putStream(String bucket, String key, InputStream stream, String streamMime) throws CloudFileException {
        if (Utils.isEmpty((String)bucket)) {
            bucket = this.bucketDef;
        }
        String uploadToken = this.auth.uploadToken(bucket);
        try {
            com.qiniu.http.Response resp = this.uploadManager.put(stream, key, uploadToken, new StringMap(), streamMime);
            return Result.succeed((Object)resp.bodyString());
        }
        catch (QiniuException e) {
            throw new CloudFileException((Throwable)e);
        }
    }

    private String buildUrl(String key) {
        if (this.endpoint.contains("://")) {
            return this.endpoint + "/" + key;
        }
        return "https://" + this.endpoint + "/" + key;
    }
}

