/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.quartz.service;

import org.noear.solon.cloud.CloudJobHandler;
import org.noear.solon.cloud.exception.CloudJobException;
import org.noear.solon.cloud.extend.quartz.JobManager;
import org.noear.solon.cloud.extend.quartz.JobQuartzProxy;
import org.noear.solon.cloud.service.CloudJobService;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class CloudJobServiceImpl
implements CloudJobService {
    public static final CloudJobServiceImpl instance = new CloudJobServiceImpl();
    Scheduler _scheduler = null;

    public void setScheduler(Scheduler scheduler) {
        if (this._scheduler == null) {
            this._scheduler = scheduler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryInitScheduler() throws SchedulerException {
        if (this._scheduler != null) return;
        Class<CloudJobServiceImpl> clazz = CloudJobServiceImpl.class;
        synchronized (CloudJobServiceImpl.class) {
            if (this._scheduler != null) return;
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            this._scheduler = schedulerFactory.getScheduler();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean register(String name, String cron7x, String description, CloudJobHandler handler) {
        JobManager.addJob(name, handler);
        JobKey jobKey = JobKey.jobKey((String)name, (String)"solon");
        try {
            this.tryInitScheduler();
            if (!this._scheduler.checkExists(jobKey)) {
                JobDetail jobDetail = JobBuilder.newJob(JobQuartzProxy.class).withDescription(description).withIdentity(jobKey).setJobData(new JobDataMap()).build();
                CronScheduleBuilder builder = CronScheduleBuilder.cronSchedule((String)cron7x);
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, "solon").startNow().withSchedule((ScheduleBuilder)builder).build();
                this._scheduler.scheduleJob(jobDetail, trigger);
            }
        }
        catch (SchedulerException e) {
            throw new CloudJobException((Throwable)e);
        }
        return true;
    }

    public boolean isRegistered(String name) {
        return JobManager.containsJob(name);
    }

    public void start() throws SchedulerException {
        this.tryInitScheduler();
        if (this._scheduler != null) {
            this._scheduler.start();
        }
    }
}

