/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.quartz;

import java.util.Map;
import org.noear.solon.cloud.CloudJobHandler;
import org.noear.solon.cloud.extend.quartz.JobManager;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.ContextUtil;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobQuartzProxy
implements Job {
    public void execute(JobExecutionContext jc) throws JobExecutionException {
        String jobId = jc.getJobDetail().getKey().getName();
        CloudJobHandler jobReal = JobManager.getJob(jobId);
        if (jobReal != null) {
            Context ctx = Context.current();
            if (ctx == null) {
                ctx = new ContextEmpty();
                ContextUtil.currentSet((Context)ctx);
            }
            for (Map.Entry kv : jc.getJobDetail().getJobDataMap().entrySet()) {
                if (kv.getValue() == null) continue;
                ctx.attrMap().put(kv.getKey(), kv.getValue());
                ctx.paramMap().put((String)kv.getKey(), (Object)kv.getValue().toString());
            }
            try {
                jobReal.handle(ctx);
            }
            catch (Throwable e) {
                throw new JobExecutionException("Job execution failed: " + jobId, e);
            }
        }
    }
}

