/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.quartz.service;

import java.util.concurrent.TimeUnit;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudJobHandler;
import org.noear.solon.cloud.exception.CloudJobException;
import org.noear.solon.cloud.extend.quartz.JobManager;
import org.noear.solon.cloud.extend.quartz.JobQuartzProxy;
import org.noear.solon.cloud.model.JobHolder;
import org.noear.solon.cloud.service.CloudJobService;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class CloudJobServiceImpl
implements CloudJobService {
    public static final CloudJobServiceImpl instance = new CloudJobServiceImpl();
    Scheduler _scheduler = null;

    public void setScheduler(Scheduler scheduler) {
        if (this._scheduler == null) {
            this._scheduler = scheduler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryInitScheduler() throws SchedulerException {
        if (this._scheduler != null) return;
        Class<CloudJobServiceImpl> clazz = CloudJobServiceImpl.class;
        synchronized (CloudJobServiceImpl.class) {
            if (this._scheduler != null) return;
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            this._scheduler = schedulerFactory.getScheduler();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean register(String name, String cron7x, String description, CloudJobHandler handler) {
        JobManager.addJob(name, new JobHolder(name, cron7x, description, handler));
        return this.registerDo(name, cron7x, description, JobQuartzProxy.class);
    }

    public boolean registerDo(String name, String cron7x, String description, Class<? extends Job> jobClz) {
        String jobGroup = Utils.annoAlias((String)Solon.cfg().appName(), (String)"solon");
        JobKey jobKey = JobKey.jobKey((String)name, (String)jobGroup);
        try {
            this.tryInitScheduler();
            if (!this._scheduler.checkExists(jobKey)) {
                if (cron7x.indexOf(" ") < 0) {
                    if (cron7x.endsWith("ms")) {
                        long period = Long.parseLong(cron7x.substring(0, cron7x.length() - 2));
                        this.regJobByPeriod(jobKey, name, description, period, TimeUnit.MILLISECONDS, jobGroup, jobClz);
                    } else if (cron7x.endsWith("s")) {
                        long period = Long.parseLong(cron7x.substring(0, cron7x.length() - 1));
                        this.regJobByPeriod(jobKey, name, description, period, TimeUnit.SECONDS, jobGroup, jobClz);
                    } else if (cron7x.endsWith("m")) {
                        long period = Long.parseLong(cron7x.substring(0, cron7x.length() - 1));
                        this.regJobByPeriod(jobKey, name, description, period, TimeUnit.MINUTES, jobGroup, jobClz);
                    } else if (cron7x.endsWith("h")) {
                        long period = Long.parseLong(cron7x.substring(0, cron7x.length() - 1));
                        this.regJobByPeriod(jobKey, name, description, period, TimeUnit.HOURS, jobGroup, jobClz);
                    } else if (cron7x.endsWith("d")) {
                        long period = Long.parseLong(cron7x.substring(0, cron7x.length() - 1));
                        this.regJobByPeriod(jobKey, name, description, period, TimeUnit.DAYS, jobGroup, jobClz);
                    }
                } else {
                    this.regJobByCron(jobKey, name, description, cron7x, jobGroup, jobClz);
                }
            }
        }
        catch (SchedulerException e) {
            throw new CloudJobException((Throwable)e);
        }
        return true;
    }

    public boolean isRegistered(String name) {
        return JobManager.containsJob(name);
    }

    public void start() throws SchedulerException {
        this.tryInitScheduler();
        if (this._scheduler != null) {
            this._scheduler.start();
        }
    }

    private void regJobByCron(JobKey jobKey, String name, String description, String cron, String jobGroup, Class<? extends Job> jobClz) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(jobClz).withDescription(description).withIdentity(jobKey).setJobData(new JobDataMap()).build();
        CronScheduleBuilder builder = CronScheduleBuilder.cronSchedule((String)cron);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, jobGroup).startNow().withSchedule((ScheduleBuilder)builder).build();
        this._scheduler.scheduleJob(jobDetail, trigger);
    }

    private void regJobByPeriod(JobKey jobKey, String name, String description, long period, TimeUnit unit, String jobGroup, Class<? extends Job> jobClz) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(jobClz).withDescription(description).withIdentity(jobKey).setJobData(new JobDataMap()).build();
        if (!this._scheduler.checkExists(jobDetail.getKey())) {
            SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule();
            switch (unit) {
                case MILLISECONDS: {
                    builder.withIntervalInMilliseconds(period);
                    break;
                }
                case SECONDS: {
                    builder.withIntervalInSeconds((int)period);
                    break;
                }
                case MINUTES: {
                    builder.withIntervalInMinutes((int)period);
                    break;
                }
                case HOURS: {
                    builder.withIntervalInHours((int)period);
                    break;
                }
                case DAYS: {
                    builder.withIntervalInHours((int)(period * 24L));
                    break;
                }
                default: {
                    return;
                }
            }
            builder.repeatForever();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, jobGroup).startNow().withSchedule((ScheduleBuilder)builder).build();
            this._scheduler.scheduleJob(jobDetail, trigger);
        }
    }
}

