/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.quartz.service;

import java.time.ZoneOffset;
import org.noear.solon.Utils;

public class Cron7X {
    private String cron;
    private ZoneOffset zone;
    private Long interval;

    public String getCron() {
        return this.cron;
    }

    public ZoneOffset getZone() {
        return this.zone;
    }

    public Long getInterval() {
        return this.interval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Cron7X parse(String cron7x) throws IllegalArgumentException {
        if (Utils.isEmpty((String)cron7x)) {
            throw new IllegalArgumentException("The cron7x expression is empty");
        }
        Cron7X tmp = new Cron7X();
        if (cron7x.indexOf(" ") < 0) {
            if (cron7x.endsWith("ms")) {
                tmp.interval = Long.parseLong(cron7x.substring(0, cron7x.length() - 2));
                return tmp;
            } else if (cron7x.endsWith("s")) {
                tmp.interval = Long.parseLong(cron7x.substring(0, cron7x.length() - 1)) * 1000L;
                return tmp;
            } else if (cron7x.endsWith("m")) {
                tmp.interval = Long.parseLong(cron7x.substring(0, cron7x.length() - 1)) * 1000L * 60L;
                return tmp;
            } else if (cron7x.endsWith("h")) {
                tmp.interval = Long.parseLong(cron7x.substring(0, cron7x.length() - 1)) * 1000L * 60L * 60L;
                return tmp;
            } else {
                if (!cron7x.endsWith("d")) throw new IllegalArgumentException("Unsupported cron7x expression: " + cron7x);
                tmp.interval = Long.parseLong(cron7x.substring(0, cron7x.length() - 1)) * 1000L * 60L * 60L * 24L;
            }
            return tmp;
        } else {
            int tzIdx = cron7x.indexOf("+");
            if (tzIdx < 0) {
                tzIdx = cron7x.indexOf("-");
            }
            if (tzIdx > 0) {
                String tz = cron7x.substring(tzIdx);
                tmp.zone = ZoneOffset.of(tz);
                tmp.cron = cron7x.substring(0, tzIdx - 1);
                return tmp;
            } else {
                tmp.cron = cron7x;
            }
        }
        return tmp;
    }
}

