/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.quartz;

import java.util.Map;
import org.noear.solon.cloud.extend.quartz.JobManager;
import org.noear.solon.cloud.model.JobHolder;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.ContextUtil;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobQuartzProxy
implements Job {
    public void execute(JobExecutionContext jc) throws JobExecutionException {
        String name = jc.getJobDetail().getKey().getName();
        JobHolder jobHolder = JobManager.getJob(name);
        if (jobHolder != null) {
            Context ctx = Context.current();
            if (ctx == null) {
                ctx = new ContextEmpty();
                ContextUtil.currentSet((Context)ctx);
            }
            if (ctx instanceof ContextEmpty) {
                ((ContextEmpty)ctx).request((Object)jc);
            }
            for (Map.Entry kv : jc.getJobDetail().getJobDataMap().entrySet()) {
                if (kv.getValue() == null) continue;
                ctx.paramMap().put((String)kv.getKey(), (Object)kv.getValue().toString());
            }
            try {
                jobHolder.handle(ctx);
            }
            catch (Throwable e) {
                throw new JobExecutionException("Job execution failed: " + name, e);
            }
        }
    }
}

