/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.quartz.service;

import java.util.TimeZone;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudJobHandler;
import org.noear.solon.cloud.exception.CloudJobException;
import org.noear.solon.cloud.extend.quartz.JobManager;
import org.noear.solon.cloud.extend.quartz.JobQuartzProxy;
import org.noear.solon.cloud.extend.quartz.service.Cron7X;
import org.noear.solon.cloud.model.JobHolder;
import org.noear.solon.cloud.service.CloudJobService;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class CloudJobServiceImpl
implements CloudJobService {
    public static final CloudJobServiceImpl instance = new CloudJobServiceImpl();
    private Scheduler _scheduler = null;

    public void setScheduler(Scheduler scheduler) {
        if (this._scheduler == null) {
            this._scheduler = scheduler;
        }
    }

    private void tryInitScheduler() throws SchedulerException {
        if (this._scheduler == null) {
            Utils.locker().lock();
            try {
                if (this._scheduler == null) {
                    StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
                    this._scheduler = schedulerFactory.getScheduler();
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
    }

    public boolean register(String name, String cron7x, String description, CloudJobHandler handler) {
        JobManager.addJob(name, new JobHolder(name, cron7x, description, handler));
        return this.registerDo(name, cron7x, description, JobQuartzProxy.class);
    }

    public boolean registerDo(String name, String cron7xStr, String description, Class<? extends Job> jobClz) {
        String jobGroup = Utils.annoAlias((String)Solon.cfg().appName(), (String)"solon");
        JobKey jobKey = JobKey.jobKey((String)name, (String)jobGroup);
        try {
            this.tryInitScheduler();
            if (!this._scheduler.checkExists(jobKey)) {
                Cron7X cron7X = Cron7X.parse(cron7xStr);
                if (Utils.isEmpty((String)cron7X.getCron())) {
                    this.regJobByPeriod(jobKey, name, description, cron7X, jobGroup, jobClz);
                } else {
                    this.regJobByCron(jobKey, name, description, cron7X, jobGroup, jobClz);
                }
            }
        }
        catch (SchedulerException e) {
            throw new CloudJobException((Throwable)e);
        }
        return true;
    }

    public boolean isRegistered(String name) {
        return JobManager.containsJob(name);
    }

    public void start() throws SchedulerException {
        this.tryInitScheduler();
        if (this._scheduler != null) {
            this._scheduler.start();
        }
    }

    private void regJobByCron(JobKey jobKey, String name, String description, Cron7X cron7X, String jobGroup, Class<? extends Job> jobClz) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(jobClz).withDescription(description).withIdentity(jobKey).setJobData(new JobDataMap()).build();
        CronScheduleBuilder builder = CronScheduleBuilder.cronSchedule((String)cron7X.getCron());
        if (cron7X.getZone() != null) {
            builder.inTimeZone(TimeZone.getTimeZone(cron7X.getZone()));
        }
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, jobGroup).withSchedule((ScheduleBuilder)builder).startNow().build();
        this._scheduler.scheduleJob(jobDetail, trigger);
    }

    private void regJobByPeriod(JobKey jobKey, String name, String description, Cron7X cron7X, String jobGroup, Class<? extends Job> jobClz) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(jobClz).withDescription(description).withIdentity(jobKey).setJobData(new JobDataMap()).build();
        SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule();
        builder.withIntervalInMilliseconds(cron7X.getInterval().longValue());
        builder.repeatForever();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, jobGroup).withSchedule((ScheduleBuilder)builder).startNow().build();
        this._scheduler.scheduleJob(jobDetail, trigger);
    }
}

