/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.service;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import org.noear.solon.Utils;
import org.noear.solon.ext.ConsumerEx;

public class RabbitMQX {
    String host;
    int port;
    String user;
    String password;
    ConnectionFactory connectionFactory;

    public RabbitMQX(String server, String user, String password) {
        if (!server.contains(":")) {
            throw new RuntimeException("RabbitX:Properties error the server parameter!");
        }
        this.host = server.split(":")[0];
        this.port = Integer.parseInt(server.split(":")[1]);
        this.user = user;
        this.password = password;
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(this.host);
        this.connectionFactory.setPort(this.port);
        if (!Utils.isEmpty((String)user)) {
            this.connectionFactory.setUsername(user);
        }
        if (!Utils.isEmpty((String)password)) {
            this.connectionFactory.setPassword(password);
        }
        this.connectionFactory.setAutomaticRecoveryEnabled(true);
        this.connectionFactory.setNetworkRecoveryInterval(10000);
    }

    public Channel createChannel() throws Exception {
        Connection connection = this.connectionFactory.newConnection();
        return connection.createChannel();
    }

    public void open0(ConsumerEx<Channel> action) {
        try (Connection connection = this.connectionFactory.newConnection();
             Channel channel = connection.createChannel();){
            action.accept((Object)channel);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

