/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.service;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import org.noear.solon.cloud.extend.rabbitmq.service.CloudEventServiceImp;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.core.event.EventBus;

public class RabbitConsumer
extends DefaultConsumer {
    CloudEventServiceImp eventServiceImp;
    String topic;

    public RabbitConsumer(Channel channel, String topic, CloudEventServiceImp eventServiceImp) {
        super(channel);
        this.topic = topic;
        this.eventServiceImp = eventServiceImp;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        Event event = new Event(this.topic, new String(body));
        try {
            this.eventServiceImp.onReceive(event);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }
}

