/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.service;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.extend.rabbitmq.RabbitmqProps;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitChannelFactory;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConsumer;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitProducer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverEntity;
import org.noear.solon.cloud.service.CloudEventService;

public class CloudEventServiceRabbitmqImp
implements CloudEventService {
    private static CloudEventServiceRabbitmqImp instance;
    RabbitProducer producer;
    RabbitConsumer consumer;
    Map<String, CloudEventObserverEntity> observerMap = new HashMap<String, CloudEventObserverEntity>();

    public static synchronized CloudEventServiceRabbitmqImp getInstance() {
        if (instance == null) {
            instance = new CloudEventServiceRabbitmqImp();
        }
        return instance;
    }

    private CloudEventServiceRabbitmqImp() {
        try {
            RabbitConfig config = new RabbitConfig();
            config.server = RabbitmqProps.instance.getEventServer();
            config.username = RabbitmqProps.instance.getUsername();
            config.password = RabbitmqProps.instance.getPassword();
            RabbitChannelFactory factory = new RabbitChannelFactory(config);
            this.producer = new RabbitProducer(factory);
            this.consumer = new RabbitConsumer(this.producer, factory);
            this.producer.init();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean publish(Event event) {
        try {
            if (Utils.isEmpty((String)event.key())) {
                event.key(Utils.guid());
            }
            return this.producer.publish(event);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void attention(EventLevel level, String channel, String group, String topic, CloudEventHandler observer) {
        if (this.observerMap.containsKey(topic)) {
            return;
        }
        this.observerMap.put(topic, new CloudEventObserverEntity(level, group, topic, observer));
    }

    public void subscribe() {
        try {
            if (this.observerMap.size() > 0) {
                this.consumer.init(this.observerMap);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

