/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.rabbitmq.RabbitmqProps;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;

public class RabbitChannelFactory {
    ConnectionFactory connectionFactory;
    RabbitConfig config;
    private Connection connection;
    private Channel channel;

    public RabbitChannelFactory(RabbitConfig cfg) {
        this.config = cfg;
        String host = this.config.server.split(":")[0];
        int port = Integer.parseInt(this.config.server.split(":")[1]);
        String virtualHost = RabbitmqProps.getEventVirtualHost();
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(host);
        this.connectionFactory.setPort(port);
        if (Utils.isNotEmpty((String)this.config.username)) {
            this.connectionFactory.setUsername(this.config.username);
        }
        if (Utils.isNotEmpty((String)this.config.password)) {
            this.connectionFactory.setPassword(this.config.password);
        }
        if (Utils.isNotEmpty((String)virtualHost)) {
            this.connectionFactory.setVirtualHost(virtualHost);
        }
        this.connectionFactory.setAutomaticRecoveryEnabled(true);
        this.connectionFactory.setNetworkRecoveryInterval(10000);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public RabbitConfig getConfig() {
        return this.config;
    }

    public Connection getConnection() throws IOException, TimeoutException {
        if (this.connection == null) {
            this.connection = this.connectionFactory.newConnection();
        }
        return this.connection;
    }

    public Channel getChannel() throws IOException, TimeoutException {
        if (this.channel == null) {
            this.channel = this.getConnection().createChannel();
        }
        return this.channel;
    }
}

