/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.rabbitmq.RabbitmqProps;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitConfig;
import org.noear.solon.cloud.extend.rabbitmq.impl.RabbitProducer;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverEntity;
import org.noear.solon.cloud.utils.ExpirationUtils;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitConsumeHandler
extends DefaultConsumer {
    static Logger log = LoggerFactory.getLogger(RabbitConsumeHandler.class);
    Map<String, CloudEventObserverEntity> observerMap;
    RabbitConfig cfg;
    RabbitProducer producer;
    String eventChannelName;

    public RabbitConsumeHandler(RabbitProducer producer, RabbitConfig config, Channel channel, Map<String, CloudEventObserverEntity> observerMap) {
        super(channel);
        this.cfg = config;
        this.producer = producer;
        this.observerMap = observerMap;
        this.eventChannelName = RabbitmqProps.instance.getEventChannel();
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        try {
            String event_json = new String(body);
            Event event = (Event)ONode.deserialize((String)event_json, Event.class);
            event.channel(this.eventChannelName);
            boolean isOk = this.onReceive(event);
            if (!isOk) {
                event.times(event.times() + 1);
                try {
                    isOk = this.producer.publish(event, this.cfg.queue_ready, ExpirationUtils.getExpiration((int)event.times()));
                }
                catch (Throwable ex) {
                    this.getChannel().basicNack(envelope.getDeliveryTag(), false, true);
                    isOk = true;
                }
            }
            if (isOk) {
                this.getChannel().basicAck(envelope.getDeliveryTag(), false);
            }
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap((Throwable)ex);
            EventBus.push((Object)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public boolean onReceive(Event event) throws Throwable {
        boolean isOk = true;
        CloudEventObserverEntity entity = null;
        entity = this.observerMap.get(event.topic());
        if (entity != null) {
            isOk = entity.handler(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)event.topic());
        }
        return isOk;
    }
}

